/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.model.po.S_role;
import com.iplatform.model.po.S_user_core;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
extends BaseServiceImpl {
    private static final String SQL_ORG_ROLES = "select * from s_role where org_id=? and del_flag=0 and status=0";
    private static final String SQL_USER_ROLES = "select r.* from s_role_user ru, s_role r where ru.user_id=? and ru.role_id=r.role_id";
    private static final String SQL_PAGE_ROLE_PREFIX = "select * from s_role where org_id=:orgId";
    private static final String SQL_UPDATE_ROLE_STATUS = "update s_role set status=? where role_id=?";
    private static final String SQL_DEL_ROLE_MENU = "delete from s_role_menu where role_id=?";
    private static final String SQL_DEL_ROLE_USER = "delete from s_role_user where role_id=?";
    private static final String SQL_DEL_ROLE_AND_USER = "delete from s_role_user where role_id=? and user_id=?";
    private static final String SQL_INSERT_ROLE_USER = "insert into s_role_user(user_id, role_id, org_id) values(?,?,0)";
    private static final String SQL_ROLE_UNALLOCATED_USER = "select u.* from s_user_core u LEFT JOIN s_role_user ru ON ru.role_id=:roleId and ru.user_id=u.id where u.org_id=:orgId and ru.user_id is null and u.del_flag=0 and u.status=0";
    private static final String SQL_ROLE_ALLOCATED_USER = "select u.* from s_role_user ru, s_user_core u where ru.role_id=:roleId and ru.user_id=u.id";
    private static final String SQL_ROLE_MENU_ID = "select menu_id from s_role_menu where role_id=?";
    private static final String SQL_QUERY_ROLE_USER = "select user_id from s_role_user where role_id=?";

    public void execInsertRoleUserList(long roleId, Long[] userIdList) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        Object[] one = null;
        Long[] longArray = userIdList;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long userId = longArray[i];
            one = new Object[]{userId, roleId};
            parameters.add(one);
        }
        this.execBatchUpdate(SQL_INSERT_ROLE_USER, parameters);
    }

    public void execDeleteRoleUser(long roleId, long userId) {
        this.execute(SQL_DEL_ROLE_AND_USER, new Object[]{roleId, userId});
    }

    public void execDeleteRole(long roleId) {
        this.execute(SQL_DEL_ROLE_MENU, new Object[]{roleId});
        this.execute(SQL_DEL_ROLE_USER, new Object[]{roleId});
        this.delete((BasePo)new S_role(Long.valueOf(roleId)));
    }

    public void execInsertRole(S_role s_role, String[] menuIds) {
        this.insert((BasePo)s_role);
        this.batchInsertRoleMenu(s_role.getRole_id(), menuIds);
    }

    public void execUpdateRole(S_role s_role, String[] menuIds) {
        this.execute(SQL_DEL_ROLE_MENU, new Object[]{s_role.getRole_id()});
        this.batchInsertRoleMenu(s_role.getRole_id(), menuIds);
        this.save((BasePo)s_role);
    }

    private void batchInsertRoleMenu(long roleId, String[] menuIdList) {
        if (menuIdList == null || menuIdList.length == 0) {
            return;
        }
        ArrayList<Object[]> parameters = new ArrayList<Object[]>(32);
        Object[] p = null;
        for (String menuId : menuIdList) {
            p = new Object[]{roleId, menuId};
            parameters.add(p);
        }
        this.execBatchUpdate("insert into s_role_menu(role_id, menu_id, org_id) values(?,?,0)", parameters);
    }

    public void execUpdateStatus(long roleId, int status) {
        this.execute(SQL_UPDATE_ROLE_STATUS, new Object[]{status, roleId});
    }

    public GenericPager<S_user_core> queryUnAllocatedUserList(long roleId, long orgId, String loginId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_ROLE_UNALLOCATED_USER);
        parameters.put("roleId", roleId);
        parameters.put("orgId", orgId);
        if (StringUtils.isNotEmpty((String)loginId)) {
            sql.append(" and u.user_name like :userName");
            parameters.put("userName", "%" + loginId + "%");
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new S_user_core());
    }

    public GenericPager<S_user_core> queryAllocatedUserList(long roleId, String loginId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_ROLE_ALLOCATED_USER);
        parameters.put("roleId", roleId);
        if (StringUtils.isNotEmpty((String)loginId)) {
            sql.append(" and u.user_name like :userName");
            parameters.put("userName", "%" + loginId + "%");
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new S_user_core());
    }

    public List<String> queryRoleMenuIdList(long roleId) {
        List listMap = this.sqlQueryListMap(SQL_ROLE_MENU_ID, new Object[]{roleId});
        if (StringUtils.isEmptyList((List)listMap)) {
            return null;
        }
        ArrayList<String> menuIdList = new ArrayList<String>(32);
        for (Map m : listMap) {
            menuIdList.add(m.get("menu_id").toString());
        }
        return menuIdList;
    }

    public int queryRoleUserSize(long roleId) {
        return this.queryForInt("select count(role_id) size from s_role_user where role_id=?", new Object[]{roleId});
    }

    public S_role queryRoleByName(long orgId, String roleName) {
        List list = this.select("select * from s_role where org_id = ? and role_name = ?", new Object[]{orgId, roleName}, (BasePo)new S_role());
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (S_role)list.get(0);
    }

    public GenericPager<S_role> queryPageRoleList(long orgId, int status, String roleName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder(SQL_PAGE_ROLE_PREFIX);
        parameters.put("orgId", orgId);
        if (status >= 0) {
            sql.append(" and status=:status");
            parameters.put("status", status);
        }
        if (StringUtils.isNotEmpty((String)roleName)) {
            sql.append(" and role_name like :roleName");
            parameters.put("roleName", "%" + roleName + "%");
        }
        PageSearch pageSearch = ListPageContext.getPageSearch();
        return this.selectSplit(sql.toString(), parameters, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new S_role());
    }

    public List<S_role> queryRoleList(long orgId) {
        return this.select(SQL_ORG_ROLES, new Object[]{orgId}, (BasePo)new S_role());
    }

    public List<S_role> queryUserRoleList(long userId) {
        return this.select(SQL_USER_ROLES, new Object[]{userId}, (BasePo)new S_role());
    }

    public List<Long> queryRoleUserIdList(long roleId) {
        List list = this.select(SQL_QUERY_ROLE_USER, new Object[]{roleId});
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        ArrayList<Long> userIdList = new ArrayList<Long>(list.size());
        for (Map map : list) {
            userIdList.add(Long.parseLong(map.get("user_id").toString()));
        }
        return userIdList;
    }
}

