/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.service;

import com.iplatform.base.DeptCacheProvider;
import com.iplatform.base.UserCacheProvider;
import com.iplatform.base.service_api.UserAndDeptServiceApi;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_dept;
import com.iplatform.model.po.S_user_core;
import com.iplatform.model.to.UserAndDeptTo;
import com.iplatform.model.to.UserAndDeptToResult;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import com.walker.web.ResponseValue;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserDeptApiServiceImpl
extends BaseServiceImpl
implements UserAndDeptServiceApi {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SQL_MAX_DEPT_ID = "select count(id) from s_dept";

    public Object execInsertMobileUserRegister(String phone) {
        return null;
    }

    @Override
    public ResponseValue execInsertTopOrgAndAdmin(UserAndDeptTo userAndDeptTo) {
        if (userAndDeptTo == null || StringUtils.isEmpty((String)userAndDeptTo.getDeptName()) || StringUtils.isEmpty((String)userAndDeptTo.getUserName())) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        UserAndDeptToResult result = new UserAndDeptToResult();
        S_dept existDept = this.existSameNameOrg(userAndDeptTo.getDeptName());
        if (existDept != null) {
            S_user_core existUser = this.existSameNameUser(userAndDeptTo.getUserName());
            if (existUser != null) {
                this.logger.warn("\u5df2\u7ecf\u5b58\u5728\u7528\u6237\u548c\u673a\u6784\uff0c\u76f4\u63a5\u8fd4\u56de\uff1adeptId={}, userId={}", (Object)existDept.getId(), (Object)existUser.getId());
                result.setDeptId(existDept.getId().longValue());
                result.setUserId(existUser.getId().longValue());
                return ResponseValue.success((Object)result);
            }
            return ResponseValue.error((String)"\u9876\u7ea7\u673a\u6784\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0");
        }
        long nextOrgId = this.queryNextDeptId();
        S_dept dept = new S_dept();
        dept.setId(Long.valueOf(nextOrgId));
        dept.setOrg_id(Long.valueOf(nextOrgId));
        dept.setOrg_type(Integer.valueOf(0));
        dept.setParent_id(Long.valueOf(0L));
        dept.setAncestors("0");
        dept.setDept_name(userAndDeptTo.getDeptName());
        dept.setCreate_by(userAndDeptTo.getCreateId());
        dept.setOrder_num(Integer.valueOf((int)nextOrgId));
        dept.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        dept.setMenu_type(Integer.valueOf(userAndDeptTo.getMenuType()));
        dept.setPhone(userAndDeptTo.getPhone());
        dept.setEmail(userAndDeptTo.getMail());
        this.insert((BasePo)dept);
        S_user_core user = new S_user_core();
        user.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        user.setCreate_time(dept.getCreate_time());
        user.setCreate_by(userAndDeptTo.getCreateId());
        user.setUpdate_time(dept.getCreate_time());
        user.setDept_id(Long.valueOf(nextOrgId));
        user.setOrg_id(Long.valueOf(nextOrgId));
        user.setUser_name(userAndDeptTo.getUserName());
        user.setNick_name(userAndDeptTo.getNickName());
        user.setUser_type(Integer.valueOf(6));
        user.setPassword(userAndDeptTo.getPassword());
        if (StringUtils.isNotEmpty((String)userAndDeptTo.getPhone())) {
            user.setPhonenumber(userAndDeptTo.getPhone());
        }
        if (StringUtils.isNotEmpty((String)userAndDeptTo.getMail())) {
            user.setEmail(userAndDeptTo.getMail());
        }
        user.setType(Integer.valueOf(6));
        user.setMer_id(Long.valueOf(nextOrgId));
        this.insert((BasePo)user);
        ((DeptCacheProvider)BeanContextAware.getBeanByType(DeptCacheProvider.class)).putDept(dept);
        ((UserCacheProvider)BeanContextAware.getBeanByType(UserCacheProvider.class)).putUser(user);
        result.setDeptId(nextOrgId);
        result.setUserId(user.getId().longValue());
        return ResponseValue.success((Object)result);
    }

    @Override
    public ResponseValue execUpdateTopOrgAndAdmin(UserAndDeptTo userAndDeptTo) {
        S_dept dept = new S_dept(Long.valueOf(userAndDeptTo.getOrgId()));
        dept.setDept_name(userAndDeptTo.getDeptName());
        dept.setEmail(userAndDeptTo.getMail());
        dept.setPhone(userAndDeptTo.getPhone());
        this.save((BasePo)dept);
        dept = (S_dept)this.get((BasePo)new S_dept(Long.valueOf(userAndDeptTo.getOrgId())));
        ((DeptCacheProvider)BeanContextAware.getBeanByType(DeptCacheProvider.class)).updateDept(dept);
        return ResponseValue.success();
    }

    private S_user_core existSameNameUser(String loginId) {
        S_user_core user = new S_user_core();
        user.setUser_name(loginId);
        List list = this.select((BasePo)user);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (S_user_core)list.get(0);
    }

    private S_dept existSameNameOrg(String name) {
        S_dept dept = new S_dept();
        dept.setDept_name(name);
        dept.setOrg_type(Integer.valueOf(0));
        List list = this.select((BasePo)dept);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (S_dept)list.get(0);
    }

    public int queryNextDeptId() {
        int maxId = this.queryForInt(SQL_MAX_DEPT_ID, new Object[0]);
        return maxId + 1;
    }
}

