/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.support;

import com.iplatform.base.service.ConfigArgumentServiceImpl;
import com.iplatform.base.util.ArgumentsManagerUtils;
import com.iplatform.core.SimpleVariable;
import com.iplatform.model.po.S_config;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Group;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.security.SystemLogMan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseArgumentsManager
extends AbstractCacheProvider<Variable>
implements ArgumentsManager {
    private ConfigArgumentServiceImpl configArgumentService = null;
    private Map<String, List<Variable>> formGroupReference = new HashMap<String, List<Variable>>();

    public void setConfigArgumentService(ConfigArgumentServiceImpl configArgumentService) {
        this.configArgumentService = configArgumentService;
        SystemLogMan.getInstance().checkMan();
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.configArgumentService.selectAll((BasePo)new S_config());
        if (!StringUtils.isEmptyList((List)hosts)) {
            SimpleVariable variable = null;
            List<Variable> groupList = null;
            for (S_config h : hosts) {
                variable = ArgumentsManagerUtils.toVariable(h.getConfig_key(), h.getConfig_value(), h.getData_type());
                cache.put(String.valueOf(h.getConfig_key()), (Object)variable);
                groupList = this.formGroupReference.get(String.valueOf(h.getForm_id()));
                if (groupList == null) {
                    groupList = new ArrayList<Variable>(8);
                    this.formGroupReference.put(String.valueOf(h.getForm_id()), groupList);
                }
                groupList.add((Variable)variable);
            }
            return hosts.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.base.arguments";
    }

    public Class<?> getProviderType() {
        return Variable.class;
    }

    public Variable getVariable(String id) {
        return (Variable)this.getCacheData(id);
    }

    public void persist(String variableId, Object value) {
        SimpleVariable variable = ArgumentsManagerUtils.toVariable(variableId, value.toString(), "string");
        this.updateCacheData(variableId, variable);
    }

    public void persist(String groupId, String variableId, Object value) {
        this.persist(variableId, value);
    }

    public void persist(List<Object[]> changedList) {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    public void insert(List<Object[]> insertList) {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    public List<Group> getGroupList() {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    public List<Variable> getVariableList(String groupId) {
        return this.formGroupReference.get(groupId);
    }

    public void setSource(Object source) {
    }
}

