/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.support;

import com.iplatform.base.service.ConfigArgumentServiceImpl;
import com.iplatform.base.util.ArgumentsManagerUtils;
import com.iplatform.core.SimpleVariable;
import com.iplatform.model.po.S_config;
import com.walker.cache.Cache;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Group;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.security.SystemLogMan;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RedisArgumentsManager
extends RedisCacheProvider<SimpleVariable>
implements ArgumentsManager {
    private ConfigArgumentServiceImpl configArgumentService = null;
    private Map<String, List<Variable>> formGroupReference = new HashMap<String, List<Variable>>();

    public void setConfigArgumentService(ConfigArgumentServiceImpl configArgumentService) {
        this.configArgumentService = configArgumentService;
        SystemLogMan.getInstance().checkMan();
    }

    public RedisArgumentsManager() {
        SystemLogMan.getInstance().checkMan();
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    protected int loadDataToCache(Cache cache) {
        List data = this.configArgumentService.selectAll((BasePo)new S_config());
        if (!StringUtils.isEmptyList((List)data)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)data.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u3010S_config\u3011\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u6570\u636e\u5e93\u4e2d\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + data.size());
                cache.clear();
                for (S_config h : data) {
                    cache.put(String.valueOf(h.getConfig_key()), (Object)ArgumentsManagerUtils.toVariable(h.getConfig_key(), h.getConfig_value(), h.getData_type()));
                }
            }
            SimpleVariable variable = null;
            List<Variable> groupList = null;
            for (S_config h : data) {
                variable = ArgumentsManagerUtils.toVariable(h.getConfig_key(), h.getConfig_value(), h.getData_type());
                groupList = this.formGroupReference.get(String.valueOf(h.getForm_id()));
                if (groupList == null) {
                    groupList = new ArrayList<Variable>(8);
                    this.formGroupReference.put(String.valueOf(h.getForm_id()), groupList);
                }
                groupList.add((Variable)variable);
            }
            return data.size();
        }
        return 0;
    }

    public SimpleVariable getVariable(String id) {
        return (SimpleVariable)this.getCacheData(id);
    }

    public void persist(String variableId, Object value) {
        SimpleVariable variable = ArgumentsManagerUtils.toVariable(variableId, value.toString(), "string");
        this.updateCacheData(variableId, variable);
    }

    public void persist(String groupId, String variableId, Object value) {
        this.persist(variableId, value);
    }

    public void persist(List<Object[]> changedList) {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    public void insert(List<Object[]> insertList) {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    public List<Group> getGroupList() {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    public List<Variable> getVariableList(String groupId) {
        return this.formGroupReference.get(groupId);
    }

    public void setSource(Object source) {
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    public String getProviderName() {
        return "cache.base.arguments";
    }

    public Class<?> getProviderType() {
        return SimpleVariable.class;
    }
}

