/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.support.httpapi;

import com.iplatform.base.service.ApiInfoServiceImpl;
import com.iplatform.base.support.httpapi.DefaultHttpApiExecute;
import com.iplatform.base.support.httpapi.EmailApiExecute;
import com.iplatform.core.httpapi.AbstractApiManager;
import com.iplatform.core.httpapi.ApiExecute;
import com.iplatform.core.httpapi.ApiInfo;
import com.iplatform.core.httpapi.ApiMethod;
import com.iplatform.core.httpapi.ApiParam;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.PushManager;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.client.RestTemplate;

public class DefaultApiManager
extends AbstractApiManager {
    private PushManager pushManager;
    private RestTemplate restTemplate;
    private ApiInfoServiceImpl apiInfoService;

    protected List<ApiExecute> acquireApiExecuteList() {
        List<ApiInfo> apiInfoList = this.apiInfoService.queryApiInfoAll();
        if (StringUtils.isEmptyList(apiInfoList)) {
            return null;
        }
        ArrayList<ApiExecute> apiExecuteList = new ArrayList<ApiExecute>(8);
        List<ApiParam> apiParamList = this.apiInfoService.queryApiParamAll();
        for (ApiInfo e : apiInfoList) {
            apiExecuteList.add(this.combineApiExecute(e, apiParamList));
        }
        return apiExecuteList;
    }

    private ApiExecute combineApiExecute(ApiInfo apiInfo, List<ApiParam> apiParamList) {
        if (apiInfo.getMethod().equals("email")) {
            EmailApiExecute emailApiExecute = new EmailApiExecute();
            emailApiExecute.setId(apiInfo.getId());
            emailApiExecute.setApiParamList(this.acquireApiInfoParams(apiInfo.getId(), apiParamList));
            emailApiExecute.setTranslate(this.acquireTranslate(apiInfo.getRequestTransClass()));
            emailApiExecute.setPushManager(this.pushManager);
            return emailApiExecute;
        }
        DefaultHttpApiExecute apiExecute = new DefaultHttpApiExecute();
        if (apiInfo.getResponseGzip() == 1) {
            apiExecute.setRestTemplate(new RestTemplate());
        } else {
            apiExecute.setRestTemplate(this.restTemplate);
        }
        apiExecute.setGzip(apiInfo.getResponseGzip() == 1);
        apiExecute.setMethod(ApiMethod.getType((String)apiInfo.getMethod()));
        apiExecute.setUrl(apiInfo.getUrl());
        apiExecute.setId(apiInfo.getId());
        apiExecute.setRequestAsText(apiInfo.getRequestAsText() == 1);
        apiExecute.setResponseTypeClazz(apiInfo.getResponseTypeClass());
        if (StringUtils.isNotEmpty((String)apiInfo.getRequestTransClass())) {
            apiExecute.setTranslate(this.acquireTranslate(apiInfo.getRequestTransClass()));
        }
        apiExecute.setApiParamList(this.acquireApiInfoParams(apiExecute.getId(), apiParamList));
        return apiExecute;
    }

    private List<ApiParam> acquireApiInfoParams(String apiInfoId, List<ApiParam> data) {
        if (StringUtils.isEmptyList(data)) {
            return null;
        }
        ArrayList<ApiParam> list = new ArrayList<ApiParam>(4);
        for (ApiParam param : data) {
            if (!param.getPid().equals(apiInfoId)) continue;
            list.add(param);
        }
        return list;
    }

    public void setApiInfoService(ApiInfoServiceImpl apiInfoService) {
        this.apiInfoService = apiInfoService;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setPushManager(PushManager pushManager) {
        this.pushManager = pushManager;
    }
}

