/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.support.httpapi;

import com.iplatform.core.httpapi.AbstractHttpApiExecute;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.web.ResponseValue;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class DefaultHttpApiExecute<V>
extends AbstractHttpApiExecute<Object, V> {
    private RestTemplate restTemplate;

    private void setupErrorResponseValue(ResponseValue<V> responseValue, String error) {
        responseValue.setCode(-1);
        responseValue.setMsg(error);
    }

    protected ResponseValue<V> getInvoke(String url, Object request, Class<V> responseType) {
        ResponseValue responseValue = ResponseValue.success(null);
        if (this.getGzip()) {
            ResponseEntity responseEntity = this.restTemplate.getForEntity(url, byte[].class, new Object[]{request});
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                this.logger.error("\u8c03\u7528{}\u8fd4\u56de\u9519\u8bef\uff1a{}", (Object)url, responseEntity.getBody());
                this.setupErrorResponseValue(responseValue, ((byte[])responseEntity.getBody()).toString());
                return responseValue;
            }
            byte[] content = (byte[])responseEntity.getBody();
            String unzipValue = this.acquireGzipContent(content);
            this.logger.debug(unzipValue);
            if (responseType == String.class) {
                responseValue.setData((Object)unzipValue);
            } else {
                try {
                    Object value = JsonUtils.jsonStringToObject((String)unzipValue, responseType);
                    responseValue.setData(value);
                }
                catch (Exception e) {
                    throw new RuntimeException("json\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u9519\u8bef\uff1a" + unzipValue, e);
                }
            }
        } else {
            ResponseEntity responseEntity = this.restTemplate.getForEntity(url, responseType, new Object[]{request});
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                this.logger.error("\u8c03\u7528{}\u8fd4\u56de\u9519\u8bef\uff1a{}", (Object)url, responseEntity.getBody());
                this.setupErrorResponseValue(responseValue, responseEntity.getBody().toString());
                return responseValue;
            }
            Object value = responseEntity.getBody();
            responseValue.setData(value);
        }
        return responseValue;
    }

    protected ResponseValue<V> postInvoke(Object request, Class<V> responseType) {
        throw new UnsupportedOperationException("\u8fd8\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

