/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.util;

import com.iplatform.base.util.cache.CategorySortComparator;
import com.iplatform.model.po.S_category;
import com.iplatform.model.vo.CategoryTreeVo;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryUtils {
    protected static Logger logger = LoggerFactory.getLogger(CategoryUtils.class);

    public static final List<CategoryTreeVo> acquireListTree(List<S_category> allTree, CategorySortComparator sortComparator) {
        Collections.sort(allTree, sortComparator);
        ArrayList<CategoryTreeVo> treeList = new ArrayList<CategoryTreeVo>();
        if (allTree.size() == 0) {
            return treeList;
        }
        for (S_category s_category : allTree) {
            treeList.add(CategoryUtils.toCategoryTreeVo(s_category));
        }
        HashMap<Integer, CategoryTreeVo> map = new HashMap<Integer, CategoryTreeVo>(treeList.size());
        for (CategoryTreeVo categoryTreeVo : treeList) {
            map.put(categoryTreeVo.getId(), categoryTreeVo);
        }
        ArrayList<CategoryTreeVo> arrayList = new ArrayList<CategoryTreeVo>();
        CategoryTreeVo parentTree = null;
        for (CategoryTreeVo tree : treeList) {
            parentTree = (CategoryTreeVo)map.get(tree.getPid());
            if (parentTree != null) {
                parentTree.getChild().add(tree);
                continue;
            }
            arrayList.add(tree);
        }
        return arrayList;
    }

    public static final boolean isCondition(S_category tempCategory, Integer type, Integer status, String name, List<Integer> categoryIdList, int owner) {
        if (owner != tempCategory.getOwner()) {
            return false;
        }
        if (type != null && type.intValue() != tempCategory.getType().intValue()) {
            return false;
        }
        if (status != null && status >= 0 && status.intValue() != tempCategory.getStatus().intValue()) {
            return false;
        }
        if (!StringUtils.isEmptyList(categoryIdList) && !categoryIdList.contains(tempCategory.getId())) {
            logger.debug("\u4e0d\u5305\u542b\u5728\u7ed9\u5b9a\u7684\u96c6\u5408\u4e2d'categoryIdList'");
            return false;
        }
        return true;
    }

    public static final CategoryTreeVo toCategoryTreeVo(S_category category) {
        CategoryTreeVo categoryTreeVo = new CategoryTreeVo();
        categoryTreeVo.setId(category.getId());
        categoryTreeVo.setName(category.getName());
        categoryTreeVo.setPid(category.getPid());
        categoryTreeVo.setExtra(category.getExtra());
        categoryTreeVo.setPath(category.getPath());
        categoryTreeVo.setSort(category.getSort());
        categoryTreeVo.setStatus(Boolean.valueOf(category.getStatus() == 1));
        categoryTreeVo.setType(category.getType());
        categoryTreeVo.setUrl(category.getUrl());
        return categoryTreeVo;
    }
}

