/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.util;

import com.iplatform.base.util.menu.SystemMenu;
import com.iplatform.model.po.S_menu;
import com.walker.infrastructure.utils.StringUtils;
import java.util.List;

public class MenuUtils {
    public static final String SECURITY_NAME_QUERY = "query";
    public static final String MENU_TYPE_FOLDER = "M";
    public static final String MENU_TYPE_ITEM = "C";
    public static final String MENU_TYPE_BUTTON = "F";
    public static final String MENU_TYPE_POINT = "A";
    public static final String MENU_ID_ROOT = "0";
    public static final String MENU_VISIBLE = "0";
    public static final String MENU_INVISIBLE = "1";
    public static final int MENU_CACHE_ENABLE = 0;
    public static final int MENU_CACHE_DISABLE = 1;
    public static final int MENU_FRAME_YES = 0;
    public static final int MENU_FRAME_NO = 1;
    public static final int MENU_STATUS_ENABLED = 0;
    public static final int MENU_STATUS_DISABLED = 1;
    public static final String LAYOUT = "Layout";
    public static final String PARENT_VIEW = "ParentView";
    public static final String INNER_LINK = "InnerLink";
    public static final int MENU_SCOPE_ORG = 4;
    public static final int MENU_SCOPE_PLATFORM = 0;
    public static final int MENU_SCOPE_ALL = -1;

    public static final boolean menuScopeNotMatch(int menuScope, S_menu menu) {
        return menuScope != -1 && (menuScope == 0 ? menu.getType() >= 4 : (menuScope == 4 ? menu.getType() != 4 : menuScope > 4 && menu.getType() != menuScope));
    }

    public static final boolean containMenu(List<SystemMenu> menuList, String menuId) {
        for (SystemMenu systemMenu : menuList) {
            if (!systemMenu.getMenu_id().equals(menuId)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String getComponent(SystemMenu menu) {
        String component = LAYOUT;
        if (StringUtils.isNotEmpty((String)menu.getComponent()) && !MenuUtils.isMenuFrame(menu)) {
            component = menu.getComponent();
        } else if (StringUtils.isEmpty((String)menu.getComponent()) && menu.getParent_id().equals("0") && MenuUtils.isInnerLink(menu)) {
            component = INNER_LINK;
        } else if (StringUtils.isEmpty((String)menu.getComponent()) && MenuUtils.isParentView(menu)) {
            component = PARENT_VIEW;
        }
        return component;
    }

    @Deprecated
    public static boolean isParentView(SystemMenu menu) {
        return !menu.getParent_id().equals("0") && MENU_TYPE_FOLDER.equals(menu.getMenu_type());
    }

    @Deprecated
    public static String getRouterPath(SystemMenu menu) {
        Object routerPath = menu.getPath();
        if (menu.getParent_id().equals("0") && MenuUtils.isInnerLink(menu)) {
            routerPath = MenuUtils.innerLinkReplaceEach((String)routerPath);
            return routerPath;
        }
        if (menu.getParent_id().equals("0") && MENU_TYPE_FOLDER.equals(menu.getMenu_type()) && menu.getIs_frame() == 1) {
            routerPath = "/" + menu.getPath();
        } else if (MenuUtils.isMenuFrame(menu)) {
            routerPath = "/";
        }
        return routerPath;
    }

    public static boolean isInnerLink(SystemMenu menu) {
        return menu.getIs_frame() == 1 && StringUtils.isHttpLink((String)menu.getPath());
    }

    public static String innerLinkReplaceEach(String path) {
        return org.apache.commons.lang3.StringUtils.replaceEach((String)path, (String[])new String[]{"http://", "https://"}, (String[])new String[]{"", ""});
    }

    public static String getRouteName(SystemMenu menu) {
        String routerName = StringUtils.capitalize((String)menu.getPath());
        if (MenuUtils.isMenuFrame(menu)) {
            routerName = "";
        }
        return routerName;
    }

    public static boolean isMenuFrame(SystemMenu menu) {
        return menu.getParent_id().equals("0") && MENU_TYPE_ITEM.equals(menu.getMenu_type()) && menu.getIs_frame() == 1;
    }

    public static final String acquireUrlFromPerms(String perms) {
        if (StringUtils.isEmpty((String)perms)) {
            throw new IllegalArgumentException("perms is required!");
        }
        String[] segments = perms.split(":");
        StringBuilder sb = new StringBuilder("/");
        for (int i = 0; i < segments.length; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            if (segments[i].equals(SECURITY_NAME_QUERY)) {
                sb.append("*");
                continue;
            }
            sb.append(segments[i]);
        }
        return sb.toString();
    }
}

