/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iplatform.base.DefaultUserPrincipal;
import com.iplatform.base.SecuritySpi;
import com.iplatform.base.pojo.UserInfo;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.UserPrincipal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UserUtils {
    public static DefaultUserPrincipal SUPER_VISOR = null;

    public static final UserInfo acquireClientUserInfo(S_user_core user_core, String token) {
        UserInfo userInfo = new UserInfo();
        userInfo.setAccount(user_core.getUser_name());
        userInfo.setRealName(user_core.getNick_name());
        userInfo.setToken(token);
        userInfo.setIsSms(false);
        return userInfo;
    }

    public static final UserPrincipal<S_user_core> createSupervisor(String supervisorPassword) {
        DefaultUserPrincipal userPrincipal;
        if (SUPER_VISOR != null) {
            return SUPER_VISOR;
        }
        S_user_core userCore = new S_user_core();
        userCore.setId(Long.valueOf(0L));
        userCore.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber((long)System.currentTimeMillis())));
        userCore.setStatus(Integer.valueOf(0));
        userCore.setUser_name("supervisor");
        userCore.setNick_name("\u8d85\u7ea7\u7ba1\u7406\u7528\u6237");
        userCore.setPassword(supervisorPassword);
        userCore.setUser_type(Integer.valueOf(0));
        userCore.setOrg_id(Long.valueOf(0L));
        userCore.setDept_id(Long.valueOf(0L));
        userCore.setMer_id(Long.valueOf(0L));
        userCore.setModify_pwd(Integer.valueOf(1));
        userCore.setIs_sms(Integer.valueOf(0));
        userCore.setType(Integer.valueOf(0));
        userCore.setProfile_id(Long.valueOf(0L));
        userCore.setIs_wechat_android(Integer.valueOf(0));
        userCore.setIs_wechat_ios(Integer.valueOf(0));
        userCore.setIs_wechat_routine(Integer.valueOf(0));
        userCore.setIs_wechat_public(Integer.valueOf(0));
        userCore.setBind_mail(Integer.valueOf(0));
        userCore.setBind_mobile(Integer.valueOf(0));
        userCore.setBind_wechat(Integer.valueOf(0));
        userCore.setBind_client_id("client_id");
        SUPER_VISOR = userPrincipal = new DefaultUserPrincipal(userCore);
        return SUPER_VISOR;
    }

    public static final S_user_core getUserInfo() {
        return ((SecuritySpi)BeanContextAware.getBeanByType(SecuritySpi.class)).getCurrentUser();
    }

    public static final UserPrincipal<S_user_core> getCurrentUserPrincipal() {
        return ((SecuritySpi)BeanContextAware.getBeanByType(SecuritySpi.class)).getCurrentUserPrincipal();
    }

    public static final DefaultUserPrincipal toUserPrincipal(String userJson) throws Exception {
        ObjectNode objectNode = JsonUtils.jsonStringToObjectNode((String)userJson);
        return UserUtils.createUserPrincipal(objectNode);
    }

    private static final DefaultUserPrincipal createUserPrincipal(ObjectNode objectNode) {
        JsonNode userInfoNode = objectNode.get("userInfo");
        S_user_core user_core = new S_user_core();
        user_core.setId(Long.valueOf(userInfoNode.get("id").asLong()));
        user_core.setUser_name(userInfoNode.get("user_name").asText());
        user_core.setPassword(userInfoNode.get("password").asText());
        user_core.setDept_id(Long.valueOf(userInfoNode.get("dept_id").asLong()));
        user_core.setNick_name(userInfoNode.get("nick_name").asText());
        user_core.setUser_type(Integer.valueOf(userInfoNode.get("user_type").asInt()));
        user_core.setCreate_time(Long.valueOf(userInfoNode.get("create_time").asLong()));
        user_core.setOrg_id(Long.valueOf(userInfoNode.get("org_id").asLong()));
        user_core.setStatus(Integer.valueOf(userInfoNode.get("status").asInt()));
        user_core.setDel_flag(Integer.valueOf(userInfoNode.get("del_flag").asInt()));
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("sex"))) {
            user_core.setSex(userInfoNode.get("sex").asText());
        } else {
            user_core.setSex("2");
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("phonenumber"))) {
            user_core.setPhonenumber(userInfoNode.get("phonenumber").asText());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("avatar"))) {
            user_core.setAvatar(userInfoNode.get("avatar").asText());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("email"))) {
            user_core.setEmail(userInfoNode.get("email").asText());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("remark"))) {
            user_core.setRemark(userInfoNode.get("remark").asText());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("create_by"))) {
            user_core.setCreate_by(userInfoNode.get("create_by").asText());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("login_date"))) {
            user_core.setLogin_date(Long.valueOf(userInfoNode.get("login_date").asLong()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("login_ip"))) {
            user_core.setLogin_ip(userInfoNode.get("login_ip").asText());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("update_by"))) {
            user_core.setUpdate_by(userInfoNode.get("update_by").asText());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("update_time"))) {
            user_core.setUpdate_time(Long.valueOf(userInfoNode.get("update_time").asLong()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("wx_open_id"))) {
            user_core.setWx_open_id(userInfoNode.get("wx_open_id").toString());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("wx_union_id"))) {
            user_core.setWx_union_id(userInfoNode.get("wx_union_id").toString());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("ding_user_id"))) {
            user_core.setDing_user_id(userInfoNode.get("ding_user_id").toString());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("bind_client_id"))) {
            user_core.setBind_client_id(userInfoNode.get("bind_client_id").toString());
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("bind_wechat"))) {
            user_core.setBind_wechat(Integer.valueOf(userInfoNode.get("bind_wechat").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("modify_pwd"))) {
            user_core.setModify_pwd(Integer.valueOf(userInfoNode.get("modify_pwd").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("bind_mobile"))) {
            user_core.setBind_mobile(Integer.valueOf(userInfoNode.get("bind_mobile").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("bind_mail"))) {
            user_core.setBind_mail(Integer.valueOf(userInfoNode.get("bind_mail").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("profile_id"))) {
            user_core.setProfile_id(Long.valueOf(userInfoNode.get("profile_id").longValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("is_wechat_public"))) {
            user_core.setIs_wechat_public(Integer.valueOf(userInfoNode.get("is_wechat_public").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("is_wechat_routine"))) {
            user_core.setIs_wechat_routine(Integer.valueOf(userInfoNode.get("is_wechat_routine").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("is_wechat_ios"))) {
            user_core.setIs_wechat_ios(Integer.valueOf(userInfoNode.get("is_wechat_ios").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("is_wechat_android"))) {
            user_core.setIs_wechat_android(Integer.valueOf(userInfoNode.get("is_wechat_android").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("is_sms"))) {
            user_core.setIs_sms(Integer.valueOf(userInfoNode.get("is_sms").intValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("mer_id"))) {
            user_core.setMer_id(Long.valueOf(userInfoNode.get("mer_id").longValue()));
        }
        if (!JsonUtils.isEmptyObject((JsonNode)userInfoNode.get("type"))) {
            user_core.setType(Integer.valueOf(userInfoNode.get("type").intValue()));
        }
        JsonNode roleIdListJson = objectNode.get("roleIdList");
        ArrayList<String> roleList = new ArrayList<String>(4);
        if (roleIdListJson.isArray()) {
            Iterator it = roleIdListJson.iterator();
            while (it.hasNext()) {
                roleList.add(((JsonNode)it.next()).asText());
            }
        }
        DefaultUserPrincipal defaultUserPrincipal = new DefaultUserPrincipal(user_core);
        defaultUserPrincipal.setRoleIdList(roleList);
        JsonNode dataScopeMap = objectNode.get("dataScopeMap");
        if (dataScopeMap != null) {
            String functionMenuId = null;
            Iterator it = dataScopeMap.fieldNames();
            while (it.hasNext()) {
                functionMenuId = (String)it.next();
                defaultUserPrincipal.addDataScope(functionMenuId, dataScopeMap.get(functionMenuId).asText());
            }
        }
        return defaultUserPrincipal;
    }

    public static final List<Long> toRoleIdLongList(List<String> roleIds) {
        if (StringUtils.isEmptyList(roleIds)) {
            return null;
        }
        ArrayList<Long> roleList = new ArrayList<Long>(4);
        for (String roleId : roleIds) {
            roleList.add(Long.parseLong(roleId));
        }
        return roleList;
    }
}

