/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.util.menu;

import com.iplatform.model.vo.MenuVo;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class MenuTree {
    private List<MenuVo> menuList = new ArrayList<MenuVo>();

    public MenuTree(List<MenuVo> menuList) {
        this.menuList = menuList;
    }

    public List<MenuVo> buildTree() {
        ArrayList<MenuVo> treeMenus = new ArrayList<MenuVo>();
        for (MenuVo menuNode : this.getRootNode()) {
            menuNode = this.buildChildTree(menuNode);
            treeMenus.add(menuNode);
        }
        return this.sortList(treeMenus);
    }

    private List<MenuVo> sortList(List<MenuVo> treeMenus) {
        treeMenus = treeMenus.stream().sorted(Comparator.comparing(MenuVo::getSort).reversed()).collect(Collectors.toList());
        treeMenus.forEach(e -> {
            if (!StringUtils.isEmptyList((List)e.getChildList())) {
                e.setChildList(this.sortList(e.getChildList()));
            }
        });
        return treeMenus;
    }

    private MenuVo buildChildTree(MenuVo pNode) {
        ArrayList<MenuVo> childMenus = new ArrayList<MenuVo>();
        for (MenuVo menuNode : this.menuList) {
            if (!menuNode.getPid().equals(pNode.getId())) continue;
            childMenus.add(this.buildChildTree(menuNode));
        }
        pNode.setChildList(childMenus);
        return pNode;
    }

    private List<MenuVo> getRootNode() {
        ArrayList<MenuVo> rootMenuLists = new ArrayList<MenuVo>();
        for (MenuVo menuNode : this.menuList) {
            if (menuNode.getPid() != 0L) continue;
            rootMenuLists.add(menuNode);
        }
        return rootMenuLists;
    }
}

