package com.iplatform.core;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.Ordered;

/**
 * 获取系统定义的 Bean 实例。
 * @author 时克英
 * @date 2022-08-25
 */
public class BeanContextAware implements ApplicationContextAware, Ordered {

    private static ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        applicationContext = ctx;
    }

    public static final String[] getBeanNamesForType(Class<?> clazz){
        return applicationContext.getBeanNamesForType(clazz);
    }

    public static final Object getBeanByName(String name){
        return applicationContext.getBean(name);
    }

    public static final <T> T getBeanByType(Class<T> clazz){
        return applicationContext.getBean(clazz);
    }

    /**
     * 发送Spring事件，目前只有角色（功能）权限变更，通知Security重新加载资源。
     * @param event
     * @date 2023-05-07
     */
    public static final void publishEvent(ApplicationEvent event){
        if(event == null){
            throw new IllegalArgumentException("event不能为空");
        }
        applicationContext.publishEvent(event);
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
