package com.iplatform.core;

/**
 * 登录策略定义。
 * <pre>
 *     1)系统支持配置多个登录策略实现，例如：同一手机号不能重复登录等。
 *     2)每种登录策略可被关闭
 * </pre>
 * @author 时克英
 * @date 2023-07-11
 */
public interface LoginStrategy {

    /**
     * 是否允许登录
     * @param loginId
     * @param clientType
     * @return
     */
    boolean allowLogin(String loginId, String clientType);

    /**
     * 如果不允许，返回错误提示
     * @return
     */
    String acquireError();

    /**
     * 策略定义名字，便于界面管理
     * @return
     */
    String getName();

    /**
     * 是否启用
     * @return
     */
    boolean isEnabled();
}
