package com.iplatform.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.arguments.VariableType;
import com.walker.infrastructure.utils.StringUtils;

/**
 * 在 Redis 中使用的并存储的参数变量对象。
 * @author 时克英
 * @date 2022-11-29
 */
public class SimpleVariable implements Variable {

//    @JsonIgnore
//    private String description = StringUtils.EMPTY_STRING;
//    @JsonIgnore
//    private int integerValue = 0;
//    @JsonIgnore
//    private boolean booleanValue = false;
//    @JsonIgnore
//    private float floatValue = 0F;
//    @JsonIgnore
//    private long longValue = 0;
//    @JsonIgnore
//    private double doubleValue = 0.0;

    private String dataType = VariableType.DEF_STRING;

    private String stringValue;

    // 数据key
    private String id;

    public SimpleVariable(){}

    public SimpleVariable(String id, String value){
        this.id = id;
        this.stringValue = value;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    @Override
    public String getDescription() {
//        return this.description;
        return null;
    }

    @JsonIgnore
    @Override
    public VariableType getType() {
        if(StringUtils.isNotEmpty(this.dataType)){
            return VariableType.getType(this.dataType);
        }
        return null;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @JsonIgnore
    @Override
    public int getIntegerValue() {
//        return this.integerValue;
        return Integer.parseInt(this.stringValue);
    }

    @JsonIgnore
    @Override
    public boolean getBooleanValue() {
//        return this.booleanValue;
        return Boolean.valueOf(this.stringValue);
    }

    @JsonIgnore
    @Override
    public float getFloatValue() {
//        return this.floatValue;
        return Float.parseFloat(this.stringValue);
    }

    @JsonIgnore
    @Override
    public long getLongValue() {
//        return this.longValue;
        return Long.parseLong(this.stringValue);
    }

    @JsonIgnore
    @Override
    public double getDoubleValue() {
//        return this.doubleValue;
        return Double.parseDouble(this.stringValue);
    }

    @JsonIgnore
    @Override
    public Object getDefaultValue() {
        return null;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}
