package com.iplatform.core;

import com.walker.infrastructure.core.NamedThreadLocal;

/**
 * Token拦截请求后，会把解析的token中关键信息放入上下文，供后续程序使用，请求完成后销毁对象。
 * @author 时克英
 * @date 2023-08-05
 */
public abstract class TokenAwareContext {

    private static final NamedThreadLocal<TokenEntity> requestLocals = new NamedThreadLocal("walker_token_threadlocal");

    public static final void setCurrentToken(TokenEntity token){
        requestLocals.set(token);
    }

    public static final TokenEntity getCurrentToken(){
        return requestLocals.get();
    }

    public static final void clearCurrentToken(){
//        System.out.println("====== clearCurrentToken");
        requestLocals.remove();
    }
}
