package com.iplatform.core;

/**
 * 商户管理员类型定义，对应：s_user_core type字段
 * @author 时克英
 * @date 2023-09-21
 */
public enum UserMerchantType {

    /**
     * 普通用户
     */
    Normal{
        public int getIndex(){
            return INDEX_NORMAL;
        }
    },

    /**
     * 平台超管
     */
    PlatformSuper{
        public int getIndex(){
            return INDEX_PLATFORM_SUPER;
        }
    },

    /**
     * 商户超管
     */
    MerchantSuper{
        public int getIndex(){
            return INDEX_MERCHANT_SUPER;
        }
    },

    /**
     * 系统管理员
     */
    Administrator{
        public int getIndex(){
            return INDEX_ADMINISTRATOR;
        }
    },

    /**
     * 商户管理员
     */
    MerchantAdmin{
        public int getIndex(){
            return INDEX_MERCHANT_ADMIN;
        }
    };

    public int getIndex(){
        throw new AbstractMethodError();
    }

    public UserMerchantType getType(int index){
        if(index == INDEX_NORMAL){
            return Normal;
        } else if(index == INDEX_PLATFORM_SUPER){
            return PlatformSuper;
        } else if(index == INDEX_ADMINISTRATOR){
            return Administrator;
        } else if(index == INDEX_MERCHANT_ADMIN){
            return MerchantAdmin;
        } else {
            throw new UnsupportedOperationException("不支持的商户管理员类型：" + index);
        }
    }

    public static final int INDEX_NORMAL = 0;
    public static final int INDEX_PLATFORM_SUPER = 1;
    public static final int INDEX_MERCHANT_SUPER = 2;
    public static final int INDEX_ADMINISTRATOR = 3;
    public static final int INDEX_MERCHANT_ADMIN = 4;
}
