package com.iplatform.core.config;

import com.iplatform.core.BeanContextAware;
import com.iplatform.core.PlatformConfiguration;
import com.walker.infrastructure.ServerId;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BasicConfig extends PlatformConfiguration {

    /**
     * 平台集群模式，配置核心参数。目前只有主机服务ID。
     * @return
     * @date 2023-09-29
     */
    @Bean
    public LoadBalanceProperties loadBalanceProperties(){
        return new LoadBalanceProperties();
    }

    @Bean
    public BeanContextAware beanContextAware(ApplicationContext applicationContext, LoadBalanceProperties loadBalanceProperties){
        // 2023-09-29 启动之前先设置负载模式，相关参数
        ServerId.setId(loadBalanceProperties.getServerId());

        BeanContextAware beanContextAware = new BeanContextAware();
        beanContextAware.setApplicationContext(applicationContext);
        return beanContextAware;
    }
}
