package com.iplatform.core.config.enc;

public class EncryptionWrapperDetector {

    private final String prefix;

    private final String suffix;

    public EncryptionWrapperDetector(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    /**
     * 检测配置参数值，是否带有加密前缀，如果是返回：true
     * @param property
     * @return
     */
    public boolean detected(String property) {
        return property != null && property.startsWith(prefix) && property.endsWith(suffix);
    }

    /**
     * 把属性值包装上加密函数
     * @param property
     * @return
     */
    public String wrapper(String property) {
        return prefix + property + suffix;
    }

    /**
     * 去掉加密函数，返回密文内容。
     * @param property
     * @return
     */
    public String unWrapper(String property) {
        return property.substring(prefix.length(), property.length() - suffix.length());
    }
}
