package com.iplatform.core.config.enc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

/**
 * 测试，实现配置文件自动加解密。
 * <pre>
 *     1）本来准备使用：jasypt-spring-boot-starter，但由于其依赖的springboot版本是2.7，所以无法使用；
 *     2）考虑到后续springBoot的频繁升级问题要连带修改，所以决定系统内部模仿实现一个简单配置。
 * </pre>
 * @author 时克英
 * @date 2023-12-04
 */
public class PropertySourcePostProcessor implements BeanFactoryPostProcessor, Ordered {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    private ConfigurableEnvironment environment;

    public PropertySourcePostProcessor(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        // 从ConfigurableEnvironment中取出所有的配置数据
        MutablePropertySources propertySources = this.environment.getPropertySources();
//        propertySources.stream()
//                // 过滤不需要包装的对象
////                .filter(s -> !noWrapPropertySource(s))
//                .filter(s -> {
//                    if(s instanceof MapPropertySource){
//                        return true;
//                    } else {
//                        return false;
//                    }
//                })
//                // 包装所有的PropertySource
//                .map(s -> new EncryptPropertySource((MapPropertySource)s))
//                .collect(Collectors.toList())
//                // 替换掉propertySources中的PropertySource
//                .forEach(wrap -> propertySources.replace(wrap.getName(), wrap));
//
//        propertySources.stream().forEach(propertySource -> {
//            logger.debug("......", propertySource);
//            logger.debug("{} -> {}", propertySource.getName(), propertySource.getSource());
//            if(propertySource instanceof MapPropertySource){
//                logger.debug("发现一个：MapPropertySource {}", propertySource.getClass().getName());
//            }
//            this.decryptPropertyValue(propertySource);
//        });
        for (PropertySource<?> propertySource : propertySources) {
            if (propertySource instanceof OriginTrackedMapPropertySource) {
                propertySources.replace(propertySource.getName(), new PropertySourceWrapper(propertySource
                                , new EncryptionWrapperDetector("ENC(", ")"))
                );
            }
        }
    }

//    private void decryptPropertyValue(PropertySource<?> propertySource){
//        Object source = propertySource.getSource();
//        logger.debug("propertySource.getSource = {}", source.getClass().getName());
//        if(source instanceof Map<?,?>){
//            Map<String, Object> properties = (Map<String, Object>)source;
//            logger.debug("map: 共有 {} 个属性", properties.size());
//            for(Map.Entry<String, Object> entry : properties.entrySet()){
//                logger.debug("key = {}, class = {}", entry.getKey(), entry.getValue().getClass().getName());
//            }
//        }
//    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE - 100;
    }
//    private boolean noWrapPropertySource(PropertySource propertySource) {
//        return propertySource instanceof EncryptPropertySource || StringUtils.equalsAny(propertySource.getClass().getName(), "org.springframework.core.env.PropertySource$StubPropertySource", "org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource");
//    }
}