package com.iplatform.core.config.enc;

import com.iplatform.core.util.AESUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertySource;

public class PropertySourceWrapper<T> extends PropertySource<T> {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

//    private final Encryptor encryptor;

    private final PropertySource<T> originalPropertySource;
    private final EncryptionWrapperDetector detector;


    public PropertySourceWrapper(PropertySource<T> originalPropertySource, EncryptionWrapperDetector detector) {
        super(originalPropertySource.getName(), originalPropertySource.getSource());
        this.originalPropertySource = originalPropertySource;
//        this.encryptor = encryptor;
        this.detector = detector;
    }

    @Override
    public Object getProperty(String name) {
        if (originalPropertySource.containsProperty(name)) {
            Object value = originalPropertySource.getProperty(name);
            if (value != null) {
                String property = value.toString();
                if (detector.detected(property)) {
//                    return encryptor.decrypt(detector.unWrapper(property));
                    logger.debug("找到加密配置：{}, value = {}", name, property);
                    return AESUtils.decryptStrAES(detector.unWrapper(property), AESUtils.KEY_16);
                }
            }
        }
        return originalPropertySource.getProperty(name);
    }
}
