package com.iplatform.core.workflow;

import com.iplatform.core.SimpleVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 抽象的流程上下文对象。<p></p>
 * 由于目前只简单集成<code>Activiti7</code>，因此该上下文对象仅针对任务环节的环境构造。
 * @author 时克英
 * @date 2023-03-28
 */
public abstract class AbstractContext implements Context{

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public SimpleVariable getVariable(String key) {
        return null;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessInstanceId() {
        return processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getTaskDefinitionId() {
        return taskDefinitionId;
    }

    public void setTaskDefinitionId(String taskDefinitionId) {
        this.taskDefinitionId = taskDefinitionId;
    }

    @Override
    public String getTaskInstanceId() {
        return taskInstanceId;
    }

    @Override
    public Actorable getActor() {
        return this.actorable;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    public void setTaskInstanceId(String taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

//    public Actorable getActorable() {
//        return actorable;
//    }

    public void setActor(Actorable actorable) {
        this.actorable = actorable;
    }

    @Override
    public String getBusinessKey() {
        return businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getActorValue() {
        return actorValue;
    }

    public void setActorValue(String actorValue) {
        this.actorValue = actorValue;
    }

    @Override
    public String getProcessDefinitionKey() {
        return processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public WorkflowForm getWorkflowForm() {
        return workflowForm;
    }

    public void setWorkflowForm(WorkflowForm workflowForm) {
        this.workflowForm = workflowForm;
    }

    private WorkflowForm workflowForm;
    private String processDefinitionKey;
    private String actorValue;
    private String businessKey;
    private Actorable actorable;
    private String creator;
    private String processDefinitionId;
    private String processInstanceId;
    private String taskDefinitionId;
    private String taskInstanceId;
}
