package com.iplatform.core.workflow;

import com.walker.infrastructure.utils.KeyValue;

import java.util.List;

/**
 * 流程参与者定义。
 * @author 时克英
 * @date 2023-03-27
 */
public interface Actorable {

    /**
     * 参与者标识，如：actor.creator
     * @return
     */
    String getId();

    /**
     * 参与者展示名字，如：创建人
     * @return
     */
    String getName();

    /**
     * 是否返回多个参与人。
     * @return
     */
    boolean isMultipleActor();

    /**
     * 是否候选用户，如果是则表明该参与者'允许指定多个人，其中1人完成就OK'
     * @return
     * @date 2023-03-28
     */
    boolean isCandidate();

    /**
     * 返回当个参与者ID。当：{@linkplain Actorable#isMultipleActor()} 返回'false'时调用。
     * <pre>
     *     1.返回的角色id，根据业务全局设计来的。
     *     2.如果返回'登录id'就全部返回，如果返回'userId'也统一都使用，两种不能混用。
     * </pre>
     * @param context 流程上下文对象
     * @return 返回单个人员，key = id, value = name
     */
    KeyValue<String, String> getActor(Context context);

    /**
     * 返回多个参与者集合。当：{@linkplain Actorable#isMultipleActor()} 返回'true'时调用。
     * @param context
     * @return
     */
    List<KeyValue<String, String>> getActorList(Context context);

    /**
     * 是否支持前端选择下一步指定人员。<p></p>
     * <pre>
     *     1.如果支持选择，则必须实现方法：getActorList()
     * </pre>
     * @return
     * @date 2023-04-11
     */
    boolean supportSelectAssignee();
}
