package com.iplatform.core.workflow;

/**
 * 流程常量定义。
 * @author 时克英
 * @date 2023-03-28
 */
public class Constants {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 一些常见参与者类型：常量定义。
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 创建人
     */
    public static final String ACTOR_TYPE_CREATOR = "actor.creator";
    /**
     * 部门领导（单人）
     */
    public static final String ACTOR_TYPE_DEPT_MANAGER = "actor.deptManager";
    /**
     * 固定指派人员（单人）
     */
    public static final String ACTOR_TYPE_FIX = "actor.fix";
    /**
     * 指定的工作组
     */
    public static final String ACTOR_TYPE_GROUP = "actor.group";
    /**
     * 指定的角色
     */
    public static final String ACTOR_TYPE_ROLE = "actor.role";
    /**
     * 指定的岗位
     */
    public static final String ACTOR_TYPE_POST = "actor.post";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 流程定义界面一些特定变量名称定义：常量定义。
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 废弃，目前直接把参数绑定到监听器上了。
     */
    @Deprecated
    public static final String NAME_ACTOR_TYPE = "actorType";
    /**
     * 废弃，目前直接把参数绑定到监听器上了。
     */
    @Deprecated
    public static final String NAME_ACTOR_VALUE = "actorValue";
    @Deprecated
    public static final String NAME_CURRENT_USER = "currentUser";

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 一些特定的常量：常量定义。
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 流程任务定义的第一步标识，必须使用：start
     * @date 2023-03-28
     */
    public static final String NAME_TASK_START = "start";

    /**
     * SQL查询流程创建人，数据库返回的字段名字。
     * @date 2023-03-28
     */
    public static final String NAME_ASSIGNEE_CREATOR = "creator";

    /**
     * 候选人界面绑定变量名字。
     * @date 2023-03-28
     */
    public static final String NAME_ASSIGNEE_CANDIDATE = "candidate";

    /**
     * 会签人集合界面绑定变量名。
     * @date 2023-03-28
     */
    public static final String NAME_ASSIGNEE_COUNTER_SIGN_LIST = "counterSignList";

    /**
     * 流转条件结果的名字，用于流程分支条件变量的名字定义。
     * @date 2023-03-28
     */
    public static final String NAME_CONDITION_RESULT = "result";

    public static final String NAME_YES = "yes";
    public static final String NAME_NO = "no";
}
