package com.iplatform.core.workflow;

import com.iplatform.core.SimpleVariable;

/**
 * 流程上下文对象定义。
 * <pre>
 *     1.该对象包含流程定义信息。
 *     2.当前任务环节描述
 *     3.提供定义的变量获取与设置方法等。
 * </pre>
 * @author 时克英
 * @date 2023-03-27
 */
public interface Context {

    /**
     * 返回业务表单对象，对于任务上下文暂时还无法获得。
     * @return
     * @date 2023-03-30
     */
    WorkflowForm getWorkflowForm();

    /**
     * 返回流程定义标识，如：demo_gongwen
     * @return
     * @date 2023-03-30
     */
    String getProcessDefinitionKey();

    String getProcessDefinitionId();

    /**
     * 返回当前任务环节变量值。
     * @param key
     * @return
     */
    SimpleVariable getVariable(String key);

    String getProcessInstanceId();

    String getTaskDefinitionId();

    String getTaskInstanceId();

    /**
     * 返回当前任务参与者对象定义。
     * @return
     * @date 2023-03-28
     */
    Actorable getActor();

    /**
     * 返回参与者模型对应的值，监听器上变量名为：actorValue
     * @return
     * @date 2023-03-30
     */
    String getActorValue();

    /**
     * 返回流程创建人登录ID（或者id），也就是流程第一步发起人。
     * @return
     * @date 2023-03-28
     */
    String getCreator();

    /**
     * 返回当前流程对应的业务ID。
     * @return
     * @date 2023-03-28
     */
    String getBusinessKey();

    /**
     * 返回当前任务执行人（登录ID），如果不存在返回 null
     * @return
     * @date 2023-03-28
     */
    String getAssignee();

    /**
     * 设置当前任务'执行人'（登录id或userId）
     * @param loginId
     * @date 2023-03-28
     */
    void setAssigner(String loginId);

    /**
     * 设置任务变量值。
     * @param key
     * @param value
     * @date 2023-03-28
     */
    void setVariable(String key, Object value);

}
