package com.iplatform.core.workflow;

import java.util.Map;

/**
 * 流程业务回调接口定义。<br>
 * 让业务有机会保存或更新数据。
 * @author 时克英
 * @date 2023-03-30
 */
public interface WorkflowCallback {

    /**
     * 返回流程定义标识，标记是哪个业务流程定义，如：demo_qingjia。
     * <pre>
     *     1.该属性必须唯一，每个流程不同。
     * </pre>
     * @return
     */
    String getProcessDefinitionKey();

    /**
     * 当任务执行提交（下一步）时，回调业务方法，实现表单等业务处理。
     * @param taskKey 任务标识，如：demo_qicao
     * @param context 流程上下文对象
     * @return 返回下一步要使用的参数变量，如果没有则为<code>null</code>
     */
    Map<String, Object> onTransitionNext(String taskKey, Context context);

}
