package com.iplatform.core.workflow;

import com.walker.infrastructure.utils.KeyValue;

import java.util.List;

/**
 * 流程表单基础对象，业务表单对象需要继承该类。
 * @author 时克英
 * @date 2023-03-30
 */
public class WorkflowForm {

    /**
     * 返回当前任务执行人，登录id或者用户id，只要统一就行。
     * @return
     */
    public String getAssignee() {
        return assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    /**
     * 返回任务实例ID
     * @return
     */
    public String getTaskInstanceId() {
        return taskInstanceId;
    }

    public void setTaskInstanceId(String taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    /**
     * 返回审批标志，同意/不同意。
     * <pre>
     *     1.字符串：yes | no
     *     2.参考常量：{@linkplain Constants#NAME_YES} | {@linkplain Constants#NAME_NO}
     * </pre>
     * @return
     */
    public String getApproveResult() {
        return approveResult;
    }

    public void setApproveResult(String approveResult) {
        this.approveResult = approveResult;
    }

    /**
     * 返回审批意见
     * @return
     */
    public String getApproveSummary() {
        return approveSummary;
    }

    public void setApproveSummary(String approveSummary) {
        this.approveSummary = approveSummary;
    }

    /**
     * 返回审批时间，字符串类型，格式：yyyy-MM-dd hh:mm:ss
     * @return
     */
    public String getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(String approveTime) {
        this.approveTime = approveTime;
    }

    /**
     * 返回业务ID
     * @return
     */
    public String getBusinessKey() {
        return businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    /**
     * 返回流程定义标识，如：demo_gongwen
     * @return
     */
    public String getProcessDefinitionKey() {
        return processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    /**
     * 返回指定的下一步任务环节标识。
     * @return
     * @date 2023-04-11
     */
    public String getAssignNextTask() {
        return assignNextTask;
    }

    public void setAssignNextTask(String assignNextTask) {
        this.assignNextTask = assignNextTask;
    }

    /**
     * 返回指定的下一步参与者人员（登录ID）
     * @return
     * @date 2023-04-11
     */
    public String getAssignNextActor() {
        return assignNextActor;
    }

    public void setAssignNextActor(String assignNextActor) {
        this.assignNextActor = assignNextActor;
    }

    /**
     * 返回后续所有任务环节参与人与任务节点集合。<p></p>
     * key = 任务定义标识，value = 参与人编号<br>，只有第一步才能提交该参数。
     * @return
     * @date 2023-04-12
     */
    public List<KeyValue<String, String>> getNextAllTaskActorList() {
        return nextAllTaskActorList;
    }

    /**
     * 设置后续所有任务环节参与人与任务节点集合，只有第一步才能提交该参数。
     * @param nextAllTaskActorList
     * @date 2023-04-12
     */
    public void setNextAllTaskActorList(List<KeyValue<String, String>> nextAllTaskActorList) {
        this.nextAllTaskActorList = nextAllTaskActorList;
    }

    private List<KeyValue<String, String>> nextAllTaskActorList = null;
    private String assignNextTask;
    private String assignNextActor;
    private String processDefinitionKey;
    private String assignee;
    private String taskInstanceId;
    private String approveResult;
    private String approveSummary;
    private String approveTime;
    private String businessKey;
}
