/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.arguments.VariableType;
import com.walker.infrastructure.utils.StringUtils;

public class SimpleVariable
implements Variable {
    private String dataType = "string";
    private String stringValue;
    private String id;

    public SimpleVariable() {
    }

    public SimpleVariable(String id, String value) {
        this.id = id;
        this.stringValue = value;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public String getDescription() {
        return null;
    }

    @JsonIgnore
    public VariableType getType() {
        if (StringUtils.isNotEmpty((String)this.dataType)) {
            return VariableType.getType((String)this.dataType);
        }
        return null;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    @JsonIgnore
    public int getIntegerValue() {
        return Integer.parseInt(this.stringValue);
    }

    @JsonIgnore
    public boolean getBooleanValue() {
        return Boolean.valueOf(this.stringValue);
    }

    @JsonIgnore
    public float getFloatValue() {
        return Float.parseFloat(this.stringValue);
    }

    @JsonIgnore
    public long getLongValue() {
        return Long.parseLong(this.stringValue);
    }

    @JsonIgnore
    public double getDoubleValue() {
        return Double.parseDouble(this.stringValue);
    }

    @JsonIgnore
    public Object getDefaultValue() {
        return null;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }
}

