/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.core.config.enc;

import com.iplatform.core.config.enc.EncryptionWrapperDetector;
import com.iplatform.core.config.enc.PropertySourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class PropertySourcePostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConfigurableEnvironment environment;

    public PropertySourcePostProcessor(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        for (PropertySource propertySource : propertySources) {
            if (!(propertySource instanceof OriginTrackedMapPropertySource)) continue;
            propertySources.replace(propertySource.getName(), new PropertySourceWrapper(propertySource, new EncryptionWrapperDetector("ENC(", ")")));
        }
    }

    public int getOrder() {
        return 2147483547;
    }
}

