/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.core.httpapi;

import com.iplatform.core.httpapi.ApiEngine;
import com.iplatform.core.httpapi.ApiException;
import com.iplatform.core.httpapi.ApiExecute;
import com.iplatform.core.httpapi.ApiManager;
import com.iplatform.core.httpapi.ApiMethod;
import com.iplatform.core.httpapi.ApiParam;
import com.iplatform.core.httpapi.ApiRequest;
import com.iplatform.core.httpapi.ApiUtils;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiEngine
implements ApiEngine {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApiManager apiManager;

    @Override
    public <V> ResponseValue<V> execute(ApiRequest apiRequest) {
        if (apiRequest == null || StringUtils.isEmpty((String)apiRequest.getAppId()) || StringUtils.isEmpty((String)apiRequest.getApiInfoId())) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u8c03\u7528apiEngine\uff0c\u53c2\u6570\u4e0d\u8db3");
        }
        ApiExecute<Object, ?> apiExecute = this.apiManager.getApiExecute(apiRequest.getApiInfoId());
        if (apiExecute == null) {
            throw new IllegalArgumentException("apiExecute\u4e0d\u5b58\u5728\uff1a" + apiRequest.getApiInfoId());
        }
        ApiMethod apiMethod = apiExecute.getMethod();
        Map<String, String> validateData = this.validateRequest(apiRequest.getData());
        if (validateData == null) {
            validateData = new HashMap<String, String>();
        }
        this.translateRequestParam(apiExecute, validateData);
        Object request = this.combineRequestParam(validateData, apiMethod, apiExecute.getRequestAsText());
        Class<?> responseType = this.apiManager.acquireResponseType(apiExecute.getResponseTypeClazz());
        ResponseValue responseValue = null;
        try {
            if (request == null) {
                this.logger.debug("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u8c03\u7528get\u8bf7\u6c42\uff1a{}", (Object)apiExecute.getUrl());
                responseValue = apiExecute.invoke(null, responseType);
            } else if (apiMethod == ApiMethod.Get) {
                this.logger.debug("\u6267\u884c\u65b9\u6cd5 get ...");
                responseValue = apiExecute.invoke(request, responseType);
            } else if (apiMethod == ApiMethod.Post) {
                this.logger.debug("\u6267\u884c\u65b9\u6cd5 post ...");
                responseValue = apiExecute.invoke(request, responseType);
            } else if (apiMethod == ApiMethod.Email) {
                this.logger.debug("\u6267\u884c\u65b9\u6cd5 email ...");
                responseValue = this.doInvokeEmail((Map)request, apiExecute, apiRequest.getAppId());
            } else {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u8c03\u7528\u65b9\u6cd5\uff1a" + apiMethod.getIndex());
            }
            this.setupSentence(responseValue, apiExecute);
            return responseValue;
        }
        catch (ApiException ex) {
            this.logger.error("\u63a5\u53e3\u670d\u52a1\u8c03\u7528\u5f02\u5e38\uff1a" + apiRequest.getApiInfoId() + ", " + ex.getMessage(), (Throwable)((Object)ex));
            throw new ApplicationRuntimeException((Throwable)((Object)ex));
        }
    }

    protected abstract ResponseValue doInvokeEmail(Map<String, String> var1, ApiExecute var2, String var3);

    protected void setupSentence(ResponseValue responseValue, ApiExecute apiExecute) {
        String sentence;
        if (apiExecute.getTranslate() != null && StringUtils.isNotEmpty((String)(sentence = apiExecute.getTranslate().acquireSentence(responseValue)))) {
            responseValue.setMsg(sentence);
        }
    }

    private Object combineRequestParam(Map<String, String> validateData, ApiMethod apiMethod, boolean requestAsText) {
        if (validateData == null || validateData.size() == 0) {
            return null;
        }
        if (apiMethod == ApiMethod.Get && requestAsText) {
            return ApiUtils.combineUrlParameters(validateData);
        }
        return validateData;
    }

    private void translateRequestParam(ApiExecute apiExecute, Map<String, String> validateData) {
        List<ApiParam> apiParamList = apiExecute.getApiParamList();
        if (StringUtils.isEmptyList(apiParamList)) {
            return;
        }
        String value = null;
        for (ApiParam param : apiParamList) {
            if (param.getNeedTranslate() == 1) {
                value = validateData.get(param.getParamKey());
                if (value == null) {
                    this.logger.warn("\u914d\u7f6e\u53c2\u6570{}\u9700\u8981\u8f6c\u6362\uff0c\u4f46\u672a\u63d0\u4f9b\u8be5\u53c2\u6570", (Object)param.getParamKey());
                    continue;
                }
                String transValue = apiExecute.getTranslate().translateTo(param.getParamKey(), value);
                validateData.put(param.getParamKey(), transValue);
                this.logger.debug("\u53c2\u6570{}\u539f\u59cb\u503c\uff1a{}\uff0c\u88ab\u8f6c\u6362\u4e3a\u65b0\u503c\uff1a{}", new Object[]{param.getParamKey(), value, transValue});
                continue;
            }
            if (param.getParamType() != 0) continue;
            validateData.put(param.getParamKey(), param.getParamFix());
            this.logger.debug("\u56fa\u5b9a\u53c2\u6570\uff0c\u76f4\u63a5\u4f7f\u7528\uff1a" + param.getParamFix());
        }
    }

    protected Map<String, String> validateRequest(Map<String, String> request) {
        return request;
    }

    @Override
    public ApiManager getApiManager() {
        return this.apiManager;
    }

    @Override
    public void setApiManager(ApiManager apiManager) {
        this.apiManager = apiManager;
    }
}

