/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.core.httpapi;

import com.iplatform.core.httpapi.ApiExecute;
import com.iplatform.core.httpapi.ApiManager;
import com.iplatform.core.httpapi.RequestTranslate;
import com.walker.infrastructure.utils.ClassUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiManager
implements ApiManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Class<?>> responseTypeClassCache = new ConcurrentHashMap();
    private Map<String, ApiExecute> apiExecuteCache = null;

    @Override
    public <P, V> ApiExecute<P, V> getApiExecute(String apiInfoId) {
        if (this.apiExecuteCache == null) {
            return null;
        }
        return this.apiExecuteCache.get(apiInfoId);
    }

    @Override
    public void load() {
        List<ApiExecute> loadApiExecuteList;
        if (this.apiExecuteCache != null) {
            this.logger.warn("\u63a5\u53e3\u6267\u884c\u96c6\u5408\u5df2\u7ecf\u5b58\u5728\uff0c\u6e05\u9664\u540e\u91cd\u65b0\u52a0\u8f7d");
            this.apiExecuteCache = null;
        }
        if (StringUtils.isEmptyList(loadApiExecuteList = this.acquireApiExecuteList())) {
            this.logger.warn("\u672a\u52a0\u8f7d\u5230\u4efb\u4f55api_info\u96c6\u5408\u6570\u636e");
            return;
        }
        HashMap<String, ApiExecute> tempMap = new HashMap<String, ApiExecute>();
        for (ApiExecute e : loadApiExecuteList) {
            tempMap.put(e.getId(), e);
        }
        this.apiExecuteCache = Collections.unmodifiableMap(tempMap);
        this.logger.info("\u6267\u884c\u4e86 ApiManager load()..., size = {}", (Object)this.apiExecuteCache.size());
    }

    @Override
    public Class<?> acquireResponseType(String clazzName) {
        if (StringUtils.isEmpty((String)clazzName)) {
            return String.class;
        }
        Class<?> exist = this.responseTypeClassCache.get(clazzName);
        if (exist != null) {
            return exist;
        }
        try {
            Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)AbstractApiManager.class.getClassLoader());
            this.responseTypeClassCache.put(clazzName, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("class.forName()\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
    }

    protected RequestTranslate acquireTranslate(String translateClazz) {
        try {
            Class clazz = ClassUtils.forName((String)translateClazz, (ClassLoader)AbstractApiManager.class.getClassLoader());
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (RequestTranslate)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("translateClazz\u672a\u627e\u5230\uff1a" + translateClazz, e);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("translateClazz\u521b\u5efa\u6784\u9020\u51fd\u6570\u9519\u8bef\uff1a" + translateClazz, ex);
        }
        catch (Exception caution) {
            throw new RuntimeException("translateClazz\u521b\u5efa\u5b9e\u4f8b\u9519\u8bef\uff1a" + translateClazz, caution);
        }
    }

    protected abstract List<ApiExecute> acquireApiExecuteList();
}

