/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.core.httpapi;

import com.iplatform.core.httpapi.AbstractApiExecute;
import com.iplatform.core.httpapi.ApiException;
import com.iplatform.core.httpapi.ApiMethod;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.zip.GZIPInputStream;

public abstract class AbstractHttpApiExecute<P, V>
extends AbstractApiExecute<P, V> {
    private boolean requestAsText = false;

    protected String acquireGzipContent(byte[] srcResponse) {
        GZIPInputStream inputStream = null;
        BufferedReader reader = null;
        StringWriter writer = null;
        try {
            String line;
            inputStream = new GZIPInputStream(new ByteArrayInputStream(srcResponse));
            reader = new BufferedReader(new InputStreamReader(inputStream));
            writer = new StringWriter();
            while ((line = reader.readLine()) != null) {
                writer.write(line);
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public ResponseValue<V> invoke(P parameter, Class<V> responseType) throws ApiException {
        if (StringUtils.isEmpty((String)this.url)) {
            throw new IllegalArgumentException("url is required!");
        }
        try {
            if (this.apiMethod == ApiMethod.Get) {
                return this.doGetInvoke(parameter, responseType);
            }
            if (this.apiMethod == ApiMethod.Post) {
                return this.postInvoke(parameter, responseType);
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff1a" + this.apiMethod.getIndex());
        }
        catch (Exception ex) {
            throw new ApiException(this.url, ex.getMessage(), ex);
        }
    }

    private ResponseValue<V> doGetInvoke(P parameter, Class<V> responseType) {
        if (parameter != null) {
            if (parameter instanceof String) {
                this.logger.debug("\u8bf7\u6c42\u53c2\u6570\uff08\u5b57\u7b26\u4e32\uff09: {}", parameter);
                String requestUrl = this.url + "?" + parameter;
                return this.getInvoke(requestUrl, null, responseType);
            }
            return this.getInvoke(this.url, parameter, responseType);
        }
        return this.getInvoke(this.url, null, responseType);
    }

    protected abstract ResponseValue<V> getInvoke(String var1, P var2, Class<V> var3);

    protected abstract ResponseValue<V> postInvoke(P var1, Class<V> var2);

    @Override
    public boolean getRequestAsText() {
        return this.requestAsText;
    }

    public void setRequestAsText(boolean requestAsText) {
        this.requestAsText = requestAsText;
    }
}

