/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.core.util;

import com.walker.infrastructure.utils.Base64;
import com.walker.infrastructure.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtils {
    private static final String AES_ALGORITHM = "AES";
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    public static boolean initialized = false;
    public static final String KEY_16 = "954327510putvwmz";

    public static String encryptStrAES(String text) {
        return AESUtils.encryptStrAES(text, KEY_16);
    }

    public static String encryptStrAES(String text, String key) {
        if (!StringUtils.hasLength((String)text)) {
            throw new IllegalStateException("encode text should not be null or empty.");
        }
        byte[] encodeBytes = AESUtils.encryptByteAES(text.getBytes(StandardCharsets.UTF_8), key);
        return new String(Base64.encodeBase64((byte[])encodeBytes));
    }

    public static String decryptStrAES(String text) {
        return AESUtils.decryptStrAES(text, KEY_16);
    }

    public static String decryptStrAES(String text, String key) {
        if (!StringUtils.hasLength((String)text)) {
            throw new IllegalStateException("decode text should not be null or empty.");
        }
        byte[] decoded = Base64.decode((byte[])text.getBytes(StandardCharsets.UTF_8));
        byte[] decodeBytes = AESUtils.decryptByteAES(decoded, key);
        return new String(decodeBytes, StandardCharsets.UTF_8);
    }

    public static byte[] encryptByteAES(byte[] originalBytes, String key) {
        if (originalBytes == null || originalBytes.length == 0) {
            throw new IllegalStateException("encode originalBytes should not be empty.");
        }
        if (!StringUtils.hasLength((String)key)) {
            throw new IllegalStateException("key :" + key + ", encode key should not be null or empty.");
        }
        Cipher cipher = AESUtils.getAESCipher(key, 1);
        byte[] encodeBytes = null;
        try {
            encodeBytes = cipher.doFinal(originalBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e.getClass().getName() + ": encode byte fail. " + e.getMessage());
        }
        return encodeBytes;
    }

    public static byte[] decryptByteAES(byte[] encryptedBytes, String key) {
        if (encryptedBytes == null || encryptedBytes.length == 0) {
            throw new IllegalStateException("decode encryptedBytes should not be empty.");
        }
        if (!StringUtils.hasLength((String)key)) {
            throw new IllegalStateException("key :" + key + ", decode key should not be null or empty.");
        }
        Cipher cipher = AESUtils.getAESCipher(key, 2);
        byte[] decodeBytes = null;
        try {
            decodeBytes = cipher.doFinal(encryptedBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e.getClass().getName() + ": decode byte fail. " + e.getMessage());
        }
        return decodeBytes;
    }

    public static Cipher getAESCipher(String key, int mode) {
        if (!StringUtils.hasLength((String)key)) {
            throw new IllegalStateException("key :" + key + ", should not be null or empty.");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(AES_ALGORITHM);
            byte[] keyBytes = key.getBytes(UTF8);
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, AES_ALGORITHM);
            cipher.init(mode, secretKey);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e.getClass().getName() + ": get cipher instance wrong. " + e.getMessage());
        }
        catch (UnsupportedEncodingException u) {
            throw new IllegalStateException(u.getClass().getName() + ": key transfer bytes fail. " + u.getMessage());
        }
        catch (InvalidKeyException i) {
            throw new IllegalStateException(i.getClass().getName() + ": key is invalid. " + i.getMessage());
        }
        return cipher;
    }

    public static final byte[] decrypt(byte[] content, byte[] keyByte, byte[] ivByte) throws InvalidAlgorithmParameterException {
        AESUtils.initialize();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            SecretKeySpec sKeySpec = new SecretKeySpec(keyByte, AES_ALGORITHM);
            cipher.init(2, (Key)sKeySpec, AESUtils.generateIV(ivByte));
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static AlgorithmParameters generateIV(byte[] iv) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance(AES_ALGORITHM);
        params.init(new IvParameterSpec(iv));
        return params;
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        initialized = true;
    }

    public static void main(String[] args) {
        String encrypt = "epFJjFcG1VY/3NrhhPBKvA==";
        System.out.println("\u89e3\u5bc6\u6570\u636e\uff1a" + AESUtils.decryptStrAES(encrypt, KEY_16));
    }
}

