package com.iplatform.file;

import com.walker.file.FileInfo;
import com.walker.file.FileStoreType;

import java.util.List;

/**
 * 文件存储回调定义，目前用于把元数据记录写入数据库中。
 * @author 时克英
 * @date 2023-02-12
 */
public interface FileStoreCallback {

    /**
     * 文件保存时触发该方法。
     * @param fileInfo
     * @param fileStoreType
     */
    void onCallback(FileInfo fileInfo, FileStoreType fileStoreType);

    FileInfo onAcquireFileInfo(String id);

    List<FileInfo> onAcquireFileInfoList(List<String> ids);
}
