package com.iplatform.file.config;

import com.iplatform.base.Constants;
import com.iplatform.base.config.FileProperties;
import com.iplatform.core.PlatformConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 专门为本地文件能被web访问的映射配置。
 * <p>注意：该配置仅针对本地文件，其他FTP或OSS方式请通过第三方链接访问文件。</p>
 * @author 时克英
 * @date 2023-06-09
 */
@Configuration
public class FileWebConfig extends PlatformConfiguration implements WebMvcConfigurer {

    private FileProperties fileProperties;

    @Autowired
    public FileWebConfig(FileProperties fileProperties){
        this.fileProperties = fileProperties;
    }

    /**
     * 添加文件浏览映射，如：file:D://images/
     * @param registry
     * @date 2023-06-09
     */
    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        // 平台上传的文件，可通过相对路径浏览。
        // 注意：这里必须添加前缀'file:'，否则会无法映射成功！2023-06-09
        String fileStorePath = "file:" + this.fileProperties.getFileRoot();
        registry.addResourceHandler(Constants.FILE_CONTEXT_PATH_MAPPING).addResourceLocations(fileStorePath);
        logger.info("映射:{}, 本地路径:{}", Constants.FILE_CONTEXT_PATH_MAPPING, fileStorePath);
    }
}
