package com.iplatform.file.controller;

import com.iplatform.base.ArgumentsConstants;
import com.iplatform.base.Constants;
import com.iplatform.base.SystemController;
import com.iplatform.file.service.FileServiceImpl;
import com.iplatform.file.util.FileResultUtils;
import com.iplatform.file.util.FileStoreUtils;
import com.iplatform.file.util.ImageUtils;
import com.iplatform.model.po.SfAttachment;
import com.walker.db.page.GenericPager;
import com.walker.file.FileInfo;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
@RequestMapping("/platform/attachment")
public class AttachmentController extends SystemController {

    private FileServiceImpl fileService = null;

    @Autowired
    public AttachmentController(FileServiceImpl fileService){
        this.fileService = fileService;
    }

    @RequestMapping(value = "/upload/file", method = RequestMethod.POST)
    public ResponseValue uploadFile(MultipartFile multipart, String model, Integer pid){
        String owner = String.valueOf(this.getOwner());
        String fileStoreType = this.getArgumentVariable(ArgumentsConstants.CONFIG_UPLOAD_TYPE).getStringValue();
        try{
            FileInfo fileInfo = null;
            if(fileStoreType.equals(FileStoreType.INDEX_FS)){
                // 本地存储
                fileInfo = this.uploadFileToLocal(multipart, null, pid, owner, Constants.UPLOAD_AFTER_FILE_KEYWORD);

            } else {
                // 远程存储
                fileInfo = this.uploadFileToRemote(multipart, null, pid, owner, Constants.UPLOAD_AFTER_FILE_KEYWORD);
            }
            return ResponseValue.success(FileResultUtils.acquireFileResultVo(fileInfo, multipart.getContentType()));

        } catch (Exception ex){
            logger.error("文件上传错误：" + ex.getMessage(), ex);
            return ResponseValue.error(ex.getMessage());
        }
    }

//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "model", value = "模块 用户user,商品product,微信wechat,文章article,系统system"),
//            @ApiImplicitParam(name = "pid", value = "分类ID 0编辑器,1商品图片,2拼团图片,3砍价图片,4秒杀图片,5文章图片,6组合数据图,7前台用户,8微信系列 ", allowableValues = "range[0,1,2,3,4,5,6,7,8]")
//    })
    @RequestMapping(value = "/upload/image", method = RequestMethod.POST)
    public ResponseValue uploadImage(MultipartFile multipart, String model, Integer pid){
        String owner = String.valueOf(this.getOwner());
        String fileStoreType = this.getArgumentVariable(ArgumentsConstants.CONFIG_UPLOAD_TYPE).getStringValue();
        try{
            FileInfo fileInfo = null;
            if(fileStoreType.equals(FileStoreType.INDEX_FS)){
                // 本地存储
                fileInfo = this.uploadFileToLocal(multipart, null, pid, owner, Constants.UPLOAD_AFTER_IMAGE_KEYWORD);

            } else {
                // 远程存储
                fileInfo = this.uploadFileToRemote(multipart, null, pid, owner, Constants.UPLOAD_AFTER_IMAGE_KEYWORD);
            }
            return ResponseValue.success(FileResultUtils.acquireFileResultVo(fileInfo, multipart.getContentType()));

        } catch (Exception ex){
            logger.error("图片上传错误：" + ex.getMessage(), ex);
            return ResponseValue.error(ex.getMessage());
        }
    }

    /**
     * 分页列出文件信息，在文件（图片）选择组件中使用。
     * @param pid
     * @param attType 文件类型，默认值：png,jpeg,jpg,audio/mpeg,text/plain,video/mp4,gif
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(Integer pid, String attType){
        List<String> attTypeList = null;
        if(StringUtils.isNotEmpty(attType)){
            attTypeList = ImageUtils.acquireFileTypeList(attType);
        }
        long owner = this.getOwner();
        logger.debug("owner = " + owner);

        GenericPager<SfAttachment> pager = this.fileService.queryPageAttachmentList((int)owner, pid, attTypeList);
        if(pager.getDatas() != null){
            String fileStoreType = null;
            for(SfAttachment attachment : pager.getDatas()){
                fileStoreType = attachment.getFileStoreType();
                if(StringUtils.isEmpty(attachment.getSattDir())){
                    continue;
                }
                attachment.setSattDir(FileStoreUtils.fileStoreTypeUrlPrefix.get(fileStoreType) + attachment.getSattDir());
            }
        }
        return ResponseValue.success(pager);
    }

//    /**
//     * 返回文件存储不同方式，对应的文件URL前缀。
//     * @param fileStoreType
//     * @return
//     */
//    private String getFileUrlPrefix(String fileStoreType){
//        String fileUrlKey = FileStoreUtils.getFileUrlPrefixKey(fileStoreType);
//        return this.getArgumentVariable(fileUrlKey).getStringValue();
//    }
}
