package com.iplatform.file.controller;

import com.iplatform.base.SystemController;
import com.iplatform.file.service.FileServiceImpl;
import com.iplatform.model.po.S_file;
import com.walker.db.page.GenericPager;
import com.walker.file.DefaultFileInfo;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

//@RestController
//@RequestMapping("/system/file")
@Deprecated
public class FileController extends SystemController {

    private FileServiceImpl fileService = null;

    @Autowired
    public FileController(FileServiceImpl fileService){
        this.fileService = fileService;
    }

    @GetMapping("/list")
    public ResponseValue list(DefaultFileInfo fileInfo){
        if(fileInfo == null){
            return ResponseValue.error("无法查询文件:没有条件");
        }
        GenericPager<S_file> pager = this.fileService.queryPageFileList(fileInfo.getFileName(), fileInfo.getFileExt(), fileInfo.getGroupId());
        return this.acquireTablePage(pager.getDatas(), pager.getTotalRows());
    }

    @RequestMapping("/remove/{fileId}")
    public ResponseValue remove(@PathVariable Long fileId){
        if(fileId == null || fileId.longValue() <= 0){
            return ResponseValue.error("文件id错误");
        }
        this.fileService.delete(new S_file(fileId));
        return ResponseValue.success();
    }
}
