package com.iplatform.file.support;

import com.iplatform.file.FileStoreCallback;
import com.walker.file.AbstractFileOperateEngine;
import com.walker.file.DefaultFileInfo;
import com.walker.file.FileInfo;

import java.util.List;

/**
 * OSS上传文件引擎抽象实现，公共代码部分。
 * @author 时克英
 * @date 2023-06-09
 */
public abstract class AbstractOssFileEngine extends AbstractFileOperateEngine {

    @Override
    protected FileInfo acquireFileInfo(String fileName) {
        return new DefaultFileInfo();
    }

    @Override
    protected void writeFileInfo(FileInfo fileInfo) {
        this.fileStoreCallback.onCallback(fileInfo, this.getFileStoreType());
    }

    @Override
    public FileInfo getFileInfo(String id) {
        return this.fileStoreCallback.onAcquireFileInfo(id);
    }

    @Override
    public List<FileInfo> getFileInfoList(List<String> ids) {
        return this.fileStoreCallback.onAcquireFileInfoList(ids);
    }

    public void setFileStoreCallback(FileStoreCallback fileStoreCallback) {
        this.fileStoreCallback = fileStoreCallback;
    }

    private FileStoreCallback fileStoreCallback = null;
}
