package com.iplatform.file.support;

import com.iplatform.file.FileStoreCallback;
import com.walker.file.FileInfo;
import com.walker.file.fs.FileSystemOperateEngine;

import java.util.List;

public class DefaultFileSystemEngine extends FileSystemOperateEngine {

    @Override
    protected void writeFileInfo(FileInfo fileInfo) {
        if(this.fileStoreCallback == null){
            throw new IllegalArgumentException("FileStoreCallback 必须设置!");
        }
        this.fileStoreCallback.onCallback(fileInfo, this.getFileStoreType());
    }

    public void setFileStoreCallback(FileStoreCallback fileStoreCallback) {
        this.fileStoreCallback = fileStoreCallback;
    }

    private FileStoreCallback fileStoreCallback = null;

    @Override
    public FileInfo getFileInfo(String id) {
        return this.fileStoreCallback.onAcquireFileInfo(id);
    }

    @Override
    public List<FileInfo> getFileInfoList(List<String> ids) {
        return this.fileStoreCallback.onAcquireFileInfoList(ids);
    }
}
