package com.iplatform.file.support;

import com.iplatform.file.FileStoreCallback;
import com.walker.file.FileInfo;
import com.walker.file.ftp.FtpFileOperateEngine;

import java.util.List;

/**
 * 默认通过JDBC方式保存文件元数据的(FTP)引擎实现。
 * @author 时克英
 * @date 2023-02-12
 */
public class DefaultFtpFileEngine extends FtpFileOperateEngine {

    @Override
    protected void writeFileInfo(FileInfo fileInfo) {
        if(this.fileStoreCallback == null){
            throw new IllegalArgumentException("FileStoreCallback 必须设置!");
        }
        this.fileStoreCallback.onCallback(fileInfo, this.getFileStoreType());
    }

    public void setFileStoreCallback(FileStoreCallback fileStoreCallback) {
        this.fileStoreCallback = fileStoreCallback;
    }

    private FileStoreCallback fileStoreCallback = null;

    @Override
    public FileInfo getFileInfo(String id) {
        return this.fileStoreCallback.onAcquireFileInfo(id);
    }

    @Override
    public List<FileInfo> getFileInfoList(List<String> ids) {
        return this.fileStoreCallback.onAcquireFileInfoList(ids);
    }
}
