package com.iplatform.file.support;

import com.iplatform.base.util.UserUtils;
import com.iplatform.file.FileStoreCallback;
import com.iplatform.file.service.FileServiceImpl;
import com.iplatform.model.po.S_file;
import com.iplatform.model.po.S_file_mapper;
import com.walker.file.DefaultFileInfo;
import com.walker.file.FileInfo;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

import java.util.ArrayList;
import java.util.List;

/**
 * 通过数据库写入上传的文件记录。
 * @author 时克英
 * @date 2023-02-14
 * @date 2023-06-05 使用新附件表（sf_attachment），参考：{@linkplain AttachmentJdbcCallback}
 */
@Deprecated
public class JdbcCallback implements FileStoreCallback {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void onCallback(FileInfo fileInfo, FileStoreType fileStoreType) {
        if(logger.isDebugEnabled()){
            logger.debug("保存文件:{}", fileInfo);
        }
        S_file s_file = new S_file();
        s_file.setId(Long.parseLong(fileInfo.getId()));
        s_file.setCreate_time(DateUtils.getDateTimeNumber(System.currentTimeMillis()));
        s_file.setUser_name(UserUtils.getUserInfo().getUser_name());
        s_file.setFile_name(fileInfo.getFileName());
        s_file.setFile_ext(fileInfo.getFileExt());
        s_file.setContent_type("");
        s_file.setFile_path(fileInfo.getUrl());
        s_file.setFile_size(fileInfo.getFileSize());
        s_file.setFile_store_type(fileStoreType.getIndex());
        if(StringUtils.isNotEmpty(fileInfo.getGroupId())){
            s_file.setGroup_id(fileInfo.getGroupId());
        }
        this.fileService.insert(s_file);

//        String fileExt = fileInfo.getFileExt();
//
//        SfAttachment attachment = new SfAttachment();
//        attachment.setAttId(Long.parseLong(fileInfo.getId()));
//        attachment.setCreateTime(DateUtils.getDateTimeNumber());
//        attachment.setUpdateTime(attachment.getCreateTime());
//        attachment.setUserName(UserUtils.getUserInfo().getUser_name());
//        attachment.setName(fileInfo.getFileName());
//        attachment.setSattDir(fileInfo.getUrl());
//        attachment.setAttType(fileExt);   // 这里目前是后缀名，后续可参考电商系统存放:mimeType
//        attachment.setAttSize(fileInfo.getFileSize());
//        attachment.setFileStoreType(fileStoreType.getIndex());
//        if(StringUtils.isNotEmpty(fileInfo.getGroupId())){
//            attachment.setGroupId(fileInfo.getGroupId());
//        }
//        if(ImageUtils.isImage(fileExt) || ImageUtils.isVideo(fileExt)){
//            // 暂时存放为1，表示媒体格式
//            attachment.setImageType(1);
//        } else {
//            // 非媒体格式
//            attachment.setImageType(0);
//        }
//        // pid 和 owner 需要传过来
//        attachment.setPid(0);
//        attachment.setOwner(-1);
//        this.fileService.insert(attachment);
    }

    @Override
    public FileInfo onAcquireFileInfo(String id) {
        S_file s_file = this.fileService.get(new S_file(Long.parseLong(id)));
        return toFileInfo(s_file);
    }

    @Override
    public List<FileInfo> onAcquireFileInfoList(List<String> ids) {
        if(StringUtils.isEmptyList(ids)){
            return null;
        }
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("ids", ids);
        List<S_file> list = this.fileService.sqlListObjectWhereIn("select * from s_file where id in(:ids)"
                , S_file_mapper.ROW_MAPPER, sqlParameterSource);
        if(StringUtils.isEmptyList(list)){
            return null;
        }
        List<FileInfo> fileInfoList = new ArrayList<>(list.size());
        for(S_file s_file : list){
            fileInfoList.add(this.toFileInfo(s_file));
        }
        return fileInfoList;
    }

    private FileInfo toFileInfo(S_file s_file){
        if(s_file == null){
            return null;
        }
        DefaultFileInfo fileInfo = new DefaultFileInfo();
        fileInfo.setId(String.valueOf(s_file.getId()));
        fileInfo.setFileSize(s_file.getFile_size());
        fileInfo.setUrl(s_file.getFile_path());
        fileInfo.setFileExt(s_file.getFile_ext());
        fileInfo.setFileName(s_file.getFile_name());
        fileInfo.setFileStoreType(FileStoreType.getType(s_file.getFile_store_type()));
        fileInfo.setGroupId(s_file.getGroup_id());
        return fileInfo;
    }

    public void setFileService(FileServiceImpl fileService) {
        this.fileService = fileService;
    }

    private FileServiceImpl fileService;
}
