package com.iplatform.file.util;

import com.iplatform.model.vo.FileResultVo;
import com.walker.file.FileInfo;
import com.walker.infrastructure.utils.StringUtils;

public class FileResultUtils {

    /**
     * 获取一个上传成功的文件信息对象。
     * @param fileInfo
     * @param contentType 文件媒体类型。
     * @return
     * @date 2023-06-09
     */
    public static final FileResultVo acquireFileResultVo(FileInfo fileInfo, String contentType){
        FileResultVo resultFile = new FileResultVo();
        resultFile.setFileSize(fileInfo.getFileSize());
        resultFile.setFileName(fileInfo.getFileName());
        resultFile.setExtName(fileInfo.getFileExt());
        resultFile.setUrl(fileInfo.getUrl());
        resultFile.setType(contentType);
        if(ImageUtils.isImage(fileInfo.getFileExt())){
            resultFile.setType(contentType.replace("image/", StringUtils.EMPTY_STRING));
        } else if(ImageUtils.isVideo(fileInfo.getFileExt())){
            resultFile.setType(contentType.replace("video/", StringUtils.EMPTY_STRING));
        } else {
            resultFile.setType(contentType.replace("file/", StringUtils.EMPTY_STRING));
        }
        return resultFile;
    }
}
