package com.iplatform.file.util;

import com.iplatform.base.ArgumentsConstants;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.utils.StringUtils;
import org.apache.poi.util.StringUtil;

import java.util.HashMap;
import java.util.Map;

public class FileStoreUtils {

    /**
     * 每种存储类型，对应一个文件访问前缀。
     * <pre>
     *     1.对于本地文件可能是 --> http://localhost:8082/admin/file/
     *     2.对第三方OSS可能是 --> http://oss.aliyun.com/xxxxx/
     *     3.前置在系统参数中统一配置。
     *     4.系统启动时，自动设置该对象。
     * </pre>
     * @date 2023-06-08
     */
    public static final Map<String, String> fileStoreTypeUrlPrefix = new HashMap<>(8);

    /**
     * 根据存储类型，返回存储文件的URL路径前缀
     * @param fileStoreType 参考：{@linkplain FileStoreType}
     * @return 如：http://localhost:8082/admin/file/
     * @date 2023-06-08
     */
    public static final String getFileUrlPrefixKey(String fileStoreType){
        String uploadUrl = StringUtils.EMPTY_STRING;
        if(fileStoreType.equals("1") || fileStoreType.equals(FileStoreType.INDEX_FS)){
            uploadUrl = ArgumentsConstants.CONFIG_LOCAL_UPLOAD_URL;
        } else if(fileStoreType.equals("2") || fileStoreType.equals(FileStoreType.INDEX_OSS_QI_NIU)){
            uploadUrl = ArgumentsConstants.CONFIG_QN_UPLOAD_URL;
        } else if(fileStoreType.equals("3") || fileStoreType.equals(FileStoreType.INDEX_OSS_ALI)){
            uploadUrl = ArgumentsConstants.CONFIG_AL_UPLOAD_URL;
        } else if(fileStoreType.equals("4") || fileStoreType.equals(FileStoreType.INDEX_OSS_TX)){
            uploadUrl = ArgumentsConstants.CONFIG_TX_UPLOAD_URL;
        } else if(fileStoreType.equals(FileStoreType.INDEX_FTP)){
//            throw new UnsupportedOperationException("ftp存储方式未设置参数！");
            uploadUrl = ArgumentsConstants.CONFIG_FTP_UPLOAD_URL;
        } else {
            throw new UnsupportedOperationException("不支持的上传类型：" + fileStoreType);
        }
        return uploadUrl;
    }
}
