package com.iplatform.file.util;

import com.walker.infrastructure.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 图像媒体工具类。
 * @author 时克英
 * @date 2023-06-02
 */
public class ImageUtils {

    /**
     * 根据传入的文件媒体类型，返回可用的文件后缀集合。
     * @param attTypes 默认值：png,jpeg,jpg,audio/mpeg,text/plain,video/mp4,gif
     * @return
     * @date 2023-06-05
     */
    public static final List<String> acquireFileTypeList(String attTypes){
        List<String> resultList = new ArrayList<>(8);
        String[] attTypeArray = StringUtils.commaDelimitedListToStringArray(attTypes);
        for(String attType : attTypeArray){
            if(attType.equals(CONTENT_TYPE_MEDIA)){
                resultList.add(VIDEO_MPEG);
                resultList.add(AUDIO_MP3);
            } else if(attType.equals(CONTENT_TYPE_VIDEO)){
                resultList.add(VIDEO_MP4);
            } else if(attType.equals(CONTENT_TYPE_TEXT)){
                resultList.add(DOC_TXT);
                resultList.add(DOC_WORD);
                resultList.add(DOC_EXCEL);
                resultList.add(DOC_PDF);
            } else {
                resultList.add(attType);
            }
        }
        return resultList;
    }

    public static final boolean isImage(String fileExt){
        if(StringUtils.isEmpty(fileExt)){
            return false;
        }
        if(fileExt.indexOf(IMAGE_JPEG) >= 0
            || fileExt.indexOf(IMAGE_JPG) >= 0
            || fileExt.indexOf(IMAGE_PNG) >= 0
            || fileExt.indexOf(IMAGE_GIF) >= 0
            || fileExt.indexOf(IMAGE_BMP) >= 0){
            return true;
        }
        return false;
    }

    public static final boolean isVideo(String fileExt){
        if(StringUtils.isEmpty(fileExt)){
            return false;
        }
        if(fileExt.indexOf(VIDEO_MP4) >= 0){
            return true;
        }
        return false;
    }

    public static final String IMAGE_JPG = "jpg";
    public static final String IMAGE_JPEG = "jpeg";
    public static final String IMAGE_PNG = "png";
    public static final String IMAGE_GIF = "gif";
    public static final String IMAGE_BMP = "bmp";
    public static final String VIDEO_MP4 = "mp4";
    public static final String VIDEO_MPEG = "mpeg";
    public static final String AUDIO_MP3 = "mp3";

    public static final String DOC_TXT = "txt";
    public static final String DOC_WORD = "docx";
//    public static final String DOC_WORD2 = "docx";
    public static final String DOC_EXCEL = "xlsx";
    public static final String DOC_PDF = "pdf";

    public static final String CONTENT_TYPE_MEDIA = "audio/mpeg";
    public static final String CONTENT_TYPE_VIDEO = "video/mp4";
    public static final String CONTENT_TYPE_TEXT = "text/plain";
}
