package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:S_FILE *
 * @author genrator
 */
@Deprecated
public class S_file_mapper extends S_file implements BaseMapper<S_file> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<S_file> ROW_MAPPER = new S_fileRowMapper();

    // 主键
    public static final String ID = "id";
    // 普通属性
    public static final String CREATE_TIME = "create_time";
    public static final String USER_NAME = "user_name";
    public static final String CONTENT_TYPE = "content_type";
    public static final String FILE_NAME = "file_name";
    public static final String FILE_EXT = "file_ext";
    public static final String FILE_PATH = "file_path";
    public static final String FILE_SIZE = "file_size";
    public static final String FILE_STORE_TYPE = "file_store_type";
    public static final String GROUP_ID = "group_id";
    public static final String SUMMARY = "summary";

    /**
     * 默认构造函数
     */
    public S_file_mapper(S_file s_file) {
        if (s_file == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (s_file.isset_id) {
            this.setId(s_file.getId());
        }
        //普通属性
        if (s_file.isset_create_time) {
            this.setCreate_time(s_file.getCreate_time());
        }
        if (s_file.isset_user_name) {
            this.setUser_name(s_file.getUser_name());
        }
        if (s_file.isset_content_type) {
            this.setContent_type(s_file.getContent_type());
        }
        if (s_file.isset_file_name) {
            this.setFile_name(s_file.getFile_name());
        }
        if (s_file.isset_file_ext) {
            this.setFile_ext(s_file.getFile_ext());
        }
        if (s_file.isset_file_path) {
            this.setFile_path(s_file.getFile_path());
        }
        if (s_file.isset_file_size) {
            this.setFile_size(s_file.getFile_size());
        }
        if (s_file.isset_file_store_type) {
            this.setFile_store_type(s_file.getFile_store_type());
        }
        if (s_file.isset_group_id) {
            this.setGroup_id(s_file.getGroup_id());
        }
        if (s_file.isset_summary) {
            this.setSummary(s_file.getSummary());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(s_file.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "s_file";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return ID;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(ID, this.getId());
        ib.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ib.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ib.set(CONTENT_TYPE, this.getContent_type(), this.isset_content_type);
        ib.set(FILE_NAME, this.getFile_name(), this.isset_file_name);
        ib.set(FILE_EXT, this.getFile_ext(), this.isset_file_ext);
        ib.set(FILE_PATH, this.getFile_path(), this.isset_file_path);
        ib.set(FILE_SIZE, this.getFile_size(), this.isset_file_size);
        ib.set(FILE_STORE_TYPE, this.getFile_store_type(), this.isset_file_store_type);
        ib.set(GROUP_ID, this.getGroup_id(), this.isset_group_id);
        ib.set(SUMMARY, this.getSummary(), this.isset_summary);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(CONTENT_TYPE, this.getContent_type(), this.isset_content_type);
        ub.set(FILE_NAME, this.getFile_name(), this.isset_file_name);
        ub.set(FILE_EXT, this.getFile_ext(), this.isset_file_ext);
        ub.set(FILE_PATH, this.getFile_path(), this.isset_file_path);
        ub.set(FILE_SIZE, this.getFile_size(), this.isset_file_size);
        ub.set(FILE_STORE_TYPE, this.getFile_store_type(), this.isset_file_store_type);
        ub.set(GROUP_ID, this.getGroup_id(), this.isset_group_id);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(CONTENT_TYPE, this.getContent_type(), this.isset_content_type);
        ub.set(FILE_NAME, this.getFile_name(), this.isset_file_name);
        ub.set(FILE_EXT, this.getFile_ext(), this.isset_file_ext);
        ub.set(FILE_PATH, this.getFile_path(), this.isset_file_path);
        ub.set(FILE_SIZE, this.getFile_size(), this.isset_file_size);
        ub.set(FILE_STORE_TYPE, this.getFile_store_type(), this.isset_file_store_type);
        ub.set(GROUP_ID, this.getGroup_id(), this.isset_group_id);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);

        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(CREATE_TIME, this.getCreate_time(), this.isset_create_time);
        ub.set(USER_NAME, this.getUser_name(), this.isset_user_name);
        ub.set(CONTENT_TYPE, this.getContent_type(), this.isset_content_type);
        ub.set(FILE_NAME, this.getFile_name(), this.isset_file_name);
        ub.set(FILE_EXT, this.getFile_ext(), this.isset_file_ext);
        ub.set(FILE_PATH, this.getFile_path(), this.isset_file_path);
        ub.set(FILE_SIZE, this.getFile_size(), this.isset_file_size);
        ub.set(FILE_STORE_TYPE, this.getFile_store_type(), this.isset_file_store_type);
        ub.set(GROUP_ID, this.getGroup_id(), this.isset_group_id);
        ub.set(SUMMARY, this.getSummary(), this.isset_summary);

        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, create_time, user_name, content_type, file_name, file_ext, file_path, file_size, file_store_type, group_id, summary from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, create_time, user_name, content_type, file_name, file_ext, file_path, file_size, file_store_type, group_id, summary from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public S_file mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public S_file toS_file() {
        return super.$clone();
    }
}

/**
 * s_file RowMapper
 *
 * @author genrator
 */
@Deprecated
class S_fileRowMapper implements RowMapper<S_file> {

    @Override
    public S_file mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        S_file s_file = new S_file();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.ID);
        if (columnIndex > 0) {
            s_file.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.CREATE_TIME);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_file.setCreate_time(null);
            } else {
                s_file.setCreate_time(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.USER_NAME);
        if (columnIndex > 0) {
            s_file.setUser_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.CONTENT_TYPE);
        if (columnIndex > 0) {
            s_file.setContent_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.FILE_NAME);
        if (columnIndex > 0) {
            s_file.setFile_name(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.FILE_EXT);
        if (columnIndex > 0) {
            s_file.setFile_ext(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.FILE_PATH);
        if (columnIndex > 0) {
            s_file.setFile_path(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.FILE_SIZE);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                s_file.setFile_size(null);
            } else {
                s_file.setFile_size(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.FILE_STORE_TYPE);
        if (columnIndex > 0) {
            s_file.setFile_store_type(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.GROUP_ID);
        if (columnIndex > 0) {
            s_file.setGroup_id(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, S_file_mapper.SUMMARY);
        if (columnIndex > 0) {
            s_file.setSummary(rs.getString(columnIndex));
        }
        return s_file;
    }
}
