
package com.iplatform.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:SF_ATTACHMENT *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class SfAttachment extends BasePo<SfAttachment> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final SfAttachment ROW_MAPPER = new SfAttachment();

    // 主键
    private Long attId = null;
    @JsonIgnore
    protected boolean isset_attId = false;

    // 属性列表
    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    private String attDir = null;
    @JsonIgnore
    protected boolean isset_attDir = false;

    private String sattDir = null;
    @JsonIgnore
    protected boolean isset_sattDir = false;

    private Long attSize = null;
    @JsonIgnore
    protected boolean isset_attSize = false;

    private String attType = null;
    @JsonIgnore
    protected boolean isset_attType = false;

    private Integer pid = null;
    @JsonIgnore
    protected boolean isset_pid = false;

    private Integer imageType = null;
    @JsonIgnore
    protected boolean isset_imageType = false;

    private Integer owner = null;
    @JsonIgnore
    protected boolean isset_owner = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    private String fileStoreType = null;
    @JsonIgnore
    protected boolean isset_fileStoreType = false;

    private String groupId = null;
    @JsonIgnore
    protected boolean isset_groupId = false;

    private String userName = null;
    @JsonIgnore
    protected boolean isset_userName = false;

    /**
     * 默认构造函数
     */
    public SfAttachment() {
    }

    /**
     * 根据主键构造对象
     */
    public SfAttachment(Long attId) {
        this.setAttId(attId);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setAttId((Long) value);
    }

    public Long getAttId() {
        return this.attId;
    }

    public void setAttId(Long attId) {
        this.attId = attId;
        this.isset_attId = true;
    }

    @JsonIgnore
    public boolean isEmptyAttId() {
        return this.attId == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
    }

    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }

    public String getAttDir() {
        return this.attDir;
    }

    public void setAttDir(String attDir) {
        this.attDir = attDir;
        this.isset_attDir = true;
    }

    @JsonIgnore
    public boolean isEmptyAttDir() {
        return this.attDir == null || this.attDir.length() == 0;
    }

    public String getSattDir() {
        return this.sattDir;
    }

    public void setSattDir(String sattDir) {
        this.sattDir = sattDir;
        this.isset_sattDir = true;
    }

    @JsonIgnore
    public boolean isEmptySattDir() {
        return this.sattDir == null || this.sattDir.length() == 0;
    }

    public Long getAttSize() {
        return this.attSize;
    }

    public void setAttSize(Long attSize) {
        this.attSize = attSize;
        this.isset_attSize = true;
    }

    @JsonIgnore
    public boolean isEmptyAttSize() {
        return this.attSize == null;
    }

    public String getAttType() {
        return this.attType;
    }

    public void setAttType(String attType) {
        this.attType = attType;
        this.isset_attType = true;
    }

    @JsonIgnore
    public boolean isEmptyAttType() {
        return this.attType == null || this.attType.length() == 0;
    }

    public Integer getPid() {
        return this.pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
        this.isset_pid = true;
    }

    @JsonIgnore
    public boolean isEmptyPid() {
        return this.pid == null;
    }

    public Integer getImageType() {
        return this.imageType;
    }

    public void setImageType(Integer imageType) {
        this.imageType = imageType;
        this.isset_imageType = true;
    }

    @JsonIgnore
    public boolean isEmptyImageType() {
        return this.imageType == null;
    }

    public Integer getOwner() {
        return this.owner;
    }

    public void setOwner(Integer owner) {
        this.owner = owner;
        this.isset_owner = true;
    }

    @JsonIgnore
    public boolean isEmptyOwner() {
        return this.owner == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    public String getFileStoreType() {
        return this.fileStoreType;
    }

    public void setFileStoreType(String fileStoreType) {
        this.fileStoreType = fileStoreType;
        this.isset_fileStoreType = true;
    }

    @JsonIgnore
    public boolean isEmptyFileStoreType() {
        return this.fileStoreType == null || this.fileStoreType.length() == 0;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
        this.isset_groupId = true;
    }

    @JsonIgnore
    public boolean isEmptyGroupId() {
        return this.groupId == null || this.groupId.length() == 0;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.isset_userName = true;
    }

    @JsonIgnore
    public boolean isEmptyUserName() {
        return this.userName == null || this.userName.length() == 0;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("attId=").append(this.attId)
                .append("name=").append(this.name)
                .append("attDir=").append(this.attDir)
                .append("sattDir=").append(this.sattDir)
                .append("attSize=").append(this.attSize)
                .append("attType=").append(this.attType)
                .append("pid=").append(this.pid)
                .append("imageType=").append(this.imageType)
                .append("owner=").append(this.owner)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .append("fileStoreType=").append(this.fileStoreType)
                .append("groupId=").append(this.groupId)
                .append("userName=").append(this.userName)
                .toString();
    }

    /**
     * 克隆
     */
    public SfAttachment $clone() {
        SfAttachment sf_attachment = new SfAttachment();

        // 数据库名称
        //sf_attachment.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_attId) {
            sf_attachment.setAttId(this.getAttId());
        }
        // 普通属性
        if (this.isset_name) {
            sf_attachment.setName(this.getName());
        }
        if (this.isset_attDir) {
            sf_attachment.setAttDir(this.getAttDir());
        }
        if (this.isset_sattDir) {
            sf_attachment.setSattDir(this.getSattDir());
        }
        if (this.isset_attSize) {
            sf_attachment.setAttSize(this.getAttSize());
        }
        if (this.isset_attType) {
            sf_attachment.setAttType(this.getAttType());
        }
        if (this.isset_pid) {
            sf_attachment.setPid(this.getPid());
        }
        if (this.isset_imageType) {
            sf_attachment.setImageType(this.getImageType());
        }
        if (this.isset_owner) {
            sf_attachment.setOwner(this.getOwner());
        }
        if (this.isset_createTime) {
            sf_attachment.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            sf_attachment.setUpdateTime(this.getUpdateTime());
        }
        if (this.isset_fileStoreType) {
            sf_attachment.setFileStoreType(this.getFileStoreType());
        }
        if (this.isset_groupId) {
            sf_attachment.setGroupId(this.getGroupId());
        }
        if (this.isset_userName) {
            sf_attachment.setUserName(this.getUserName());
        }
        return sf_attachment;
    }
}
