package com.iplatform.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:SF_ATTACHMENT *
 * @author genrator
 */
public class SfAttachment_mapper extends SfAttachment implements BaseMapper<SfAttachment> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<SfAttachment> ROW_MAPPER = new SfAttachmentRowMapper();

    // 主键
    public static final String AttId = "att_id";
    // 普通属性
    public static final String Name = "name";
    public static final String AttDir = "att_dir";
    public static final String SattDir = "satt_dir";
    public static final String AttSize = "att_size";
    public static final String AttType = "att_type";
    public static final String Pid = "pid";
    public static final String ImageType = "image_type";
    public static final String Owner = "owner";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";
    public static final String FileStoreType = "file_store_type";
    public static final String GroupId = "group_id";
    public static final String UserName = "user_name";

    /**
     * 默认构造函数
     */
    public SfAttachment_mapper(SfAttachment sfAttachment) {
        if (sfAttachment == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (sfAttachment.isset_attId) {
            this.setAttId(sfAttachment.getAttId());
        }
        //普通属性
        if (sfAttachment.isset_name) {
            this.setName(sfAttachment.getName());
        }
        if (sfAttachment.isset_attDir) {
            this.setAttDir(sfAttachment.getAttDir());
        }
        if (sfAttachment.isset_sattDir) {
            this.setSattDir(sfAttachment.getSattDir());
        }
        if (sfAttachment.isset_attSize) {
            this.setAttSize(sfAttachment.getAttSize());
        }
        if (sfAttachment.isset_attType) {
            this.setAttType(sfAttachment.getAttType());
        }
        if (sfAttachment.isset_pid) {
            this.setPid(sfAttachment.getPid());
        }
        if (sfAttachment.isset_imageType) {
            this.setImageType(sfAttachment.getImageType());
        }
        if (sfAttachment.isset_owner) {
            this.setOwner(sfAttachment.getOwner());
        }
        if (sfAttachment.isset_createTime) {
            this.setCreateTime(sfAttachment.getCreateTime());
        }
        if (sfAttachment.isset_updateTime) {
            this.setUpdateTime(sfAttachment.getUpdateTime());
        }
        if (sfAttachment.isset_fileStoreType) {
            this.setFileStoreType(sfAttachment.getFileStoreType());
        }
        if (sfAttachment.isset_groupId) {
            this.setGroupId(sfAttachment.getGroupId());
        }
        if (sfAttachment.isset_userName) {
            this.setUserName(sfAttachment.getUserName());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(sf_attachment.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "sf_attachment";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return AttId;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getAttId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(AttId, this.getAttId());
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(AttDir, this.getAttDir(), this.isset_attDir);
        ib.set(SattDir, this.getSattDir(), this.isset_sattDir);
        ib.set(AttSize, this.getAttSize(), this.isset_attSize);
        ib.set(AttType, this.getAttType(), this.isset_attType);
        ib.set(Pid, this.getPid(), this.isset_pid);
        ib.set(ImageType, this.getImageType(), this.isset_imageType);
        ib.set(Owner, this.getOwner(), this.isset_owner);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ib.set(FileStoreType, this.getFileStoreType(), this.isset_fileStoreType);
        ib.set(GroupId, this.getGroupId(), this.isset_groupId);
        ib.set(UserName, this.getUserName(), this.isset_userName);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(AttDir, this.getAttDir(), this.isset_attDir);
        ub.set(SattDir, this.getSattDir(), this.isset_sattDir);
        ub.set(AttSize, this.getAttSize(), this.isset_attSize);
        ub.set(AttType, this.getAttType(), this.isset_attType);
        ub.set(Pid, this.getPid(), this.isset_pid);
        ub.set(ImageType, this.getImageType(), this.isset_imageType);
        ub.set(Owner, this.getOwner(), this.isset_owner);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(FileStoreType, this.getFileStoreType(), this.isset_fileStoreType);
        ub.set(GroupId, this.getGroupId(), this.isset_groupId);
        ub.set(UserName, this.getUserName(), this.isset_userName);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(AttDir, this.getAttDir(), this.isset_attDir);
        ub.set(SattDir, this.getSattDir(), this.isset_sattDir);
        ub.set(AttSize, this.getAttSize(), this.isset_attSize);
        ub.set(AttType, this.getAttType(), this.isset_attType);
        ub.set(Pid, this.getPid(), this.isset_pid);
        ub.set(ImageType, this.getImageType(), this.isset_imageType);
        ub.set(Owner, this.getOwner(), this.isset_owner);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(FileStoreType, this.getFileStoreType(), this.isset_fileStoreType);
        ub.set(GroupId, this.getGroupId(), this.isset_groupId);
        ub.set(UserName, this.getUserName(), this.isset_userName);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(AttDir, this.getAttDir(), this.isset_attDir);
        ub.set(SattDir, this.getSattDir(), this.isset_sattDir);
        ub.set(AttSize, this.getAttSize(), this.isset_attSize);
        ub.set(AttType, this.getAttType(), this.isset_attType);
        ub.set(Pid, this.getPid(), this.isset_pid);
        ub.set(ImageType, this.getImageType(), this.isset_imageType);
        ub.set(Owner, this.getOwner(), this.isset_owner);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(FileStoreType, this.getFileStoreType(), this.isset_fileStoreType);
        ub.set(GroupId, this.getGroupId(), this.isset_groupId);
        ub.set(UserName, this.getUserName(), this.isset_userName);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select att_id, name, att_dir, satt_dir, att_size, att_type, pid, image_type, owner, create_time, update_time, file_store_type, group_id, user_name from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select att_id, name, att_dir, satt_dir, att_size, att_type, pid, image_type, owner, create_time, update_time, file_store_type, group_id, user_name from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public SfAttachment mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public SfAttachment toSfAttachment() {
        return super.$clone();
    }
}

/**
 * sf_attachment RowMapper
 *
 * @author genrator
 */
class SfAttachmentRowMapper implements RowMapper<SfAttachment> {

    @Override
    public SfAttachment mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        SfAttachment sf_attachment = new SfAttachment();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.AttId);
        if (columnIndex > 0) {
            sf_attachment.setAttId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.Name);
        if (columnIndex > 0) {
            sf_attachment.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.AttDir);
        if (columnIndex > 0) {
            sf_attachment.setAttDir(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.SattDir);
        if (columnIndex > 0) {
            sf_attachment.setSattDir(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.AttSize);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_attachment.setAttSize(null);
            } else {
                sf_attachment.setAttSize(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.AttType);
        if (columnIndex > 0) {
            sf_attachment.setAttType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.Pid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_attachment.setPid(null);
            } else {
                sf_attachment.setPid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.ImageType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_attachment.setImageType(null);
            } else {
                sf_attachment.setImageType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.Owner);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_attachment.setOwner(null);
            } else {
                sf_attachment.setOwner(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_attachment.setCreateTime(null);
            } else {
                sf_attachment.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                sf_attachment.setUpdateTime(null);
            } else {
                sf_attachment.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.FileStoreType);
        if (columnIndex > 0) {
            sf_attachment.setFileStoreType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.GroupId);
        if (columnIndex > 0) {
            sf_attachment.setGroupId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, SfAttachment_mapper.UserName);
        if (columnIndex > 0) {
            sf_attachment.setUserName(rs.getString(columnIndex));
        }
        return sf_attachment;
    }
}
