/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file.config;

import com.iplatform.base.config.FileProperties;
import com.iplatform.file.FileEngineFactory;
import com.iplatform.file.FileStoreCallback;
import com.iplatform.file.config.FtpProperties;
import com.iplatform.file.service.FileServiceImpl;
import com.iplatform.file.support.AliOssFileEngine;
import com.iplatform.file.support.AttachmentJdbcCallback;
import com.iplatform.file.support.DefaultFileSystemEngine;
import com.iplatform.file.support.DefaultFtpFileEngine;
import com.iplatform.file.support.QnOssFileEngine;
import com.iplatform.file.support.TxOssFileEngine;
import com.walker.file.FileOperateEngine;
import com.walker.file.FileStoreType;
import com.walker.file.ftp.FtpConfig;
import com.walker.infrastructure.arguments.ArgumentsManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FileConfig {
    @Bean
    public FileEngineFactory fileEngineFactory(DefaultFtpFileEngine ftpFileEngine, DefaultFileSystemEngine fileSystemEngine, QnOssFileEngine qnOssFileEngine, TxOssFileEngine txOssFileEngine, AliOssFileEngine aliOssFileEngine, ArgumentsManager argumentsManager, FileProperties fileProperties) {
        FileEngineFactory fileEngineFactory = new FileEngineFactory();
        fileEngineFactory.register(FileStoreType.Ftp, (FileOperateEngine)ftpFileEngine);
        fileEngineFactory.register(FileStoreType.FileSystem, (FileOperateEngine)fileSystemEngine);
        fileEngineFactory.register(FileStoreType.OssQiNiu, (FileOperateEngine)qnOssFileEngine);
        fileEngineFactory.register(FileStoreType.OssTx, (FileOperateEngine)txOssFileEngine);
        fileEngineFactory.register(FileStoreType.OssAli, (FileOperateEngine)aliOssFileEngine);
        fileEngineFactory.setArgumentsManager(argumentsManager);
        fileEngineFactory.setRemoteAsLocal(fileProperties.isRemoteAsLocal());
        fileEngineFactory.startup();
        return fileEngineFactory;
    }

    @Bean
    public AliOssFileEngine aliOssFileEngine(FileProperties fileProperties, FileStoreCallback fileStoreCallback) {
        AliOssFileEngine engine = new AliOssFileEngine();
        engine.setFileRoot(fileProperties.getFileRoot());
        engine.setFileStoreCallback(fileStoreCallback);
        return engine;
    }

    @Bean
    public TxOssFileEngine txOssFileEngine(FileProperties fileProperties, FileStoreCallback fileStoreCallback) {
        TxOssFileEngine engine = new TxOssFileEngine();
        engine.setFileRoot(fileProperties.getFileRoot());
        engine.setFileStoreCallback(fileStoreCallback);
        return engine;
    }

    @Bean
    public QnOssFileEngine qnOssFileEngine(FileProperties fileProperties, FileStoreCallback fileStoreCallback) {
        QnOssFileEngine engine = new QnOssFileEngine();
        engine.setFileRoot(fileProperties.getFileRoot());
        engine.setFileStoreCallback(fileStoreCallback);
        return engine;
    }

    @Bean
    public DefaultFileSystemEngine defaultFileSystemEngine(FileProperties fileProperties, FileServiceImpl fileService) {
        DefaultFileSystemEngine fileSystemEngine = new DefaultFileSystemEngine();
        fileSystemEngine.setFileRoot(fileProperties.getFileRoot());
        fileSystemEngine.setFileStoreCallback(this.fileStoreCallback(fileService));
        return fileSystemEngine;
    }

    @Bean
    public DefaultFtpFileEngine defaultFtpFileEngine(FtpProperties ftpProperties, FileServiceImpl fileService) {
        FtpConfig ftpConfig = new FtpConfig();
        ftpConfig.setIp(ftpProperties.getIp());
        ftpConfig.setPort(ftpProperties.getPort());
        ftpConfig.setUserName(ftpProperties.getUserName());
        ftpConfig.setPassword(ftpProperties.getPassword());
        ftpConfig.setPrivateKey(ftpProperties.getPrivateKey());
        DefaultFtpFileEngine ftpFileEngine = new DefaultFtpFileEngine();
        ftpFileEngine.setFileRoot(ftpProperties.getFileRoot());
        ftpFileEngine.setFtpConfig(ftpConfig);
        ftpFileEngine.setFileStoreCallback(this.fileStoreCallback(fileService));
        return ftpFileEngine;
    }

    @Bean
    public FtpProperties ftpProperties() {
        return new FtpProperties();
    }

    @Bean
    public AttachmentJdbcCallback fileStoreCallback(FileServiceImpl fileService) {
        AttachmentJdbcCallback jdbcCallback = new AttachmentJdbcCallback();
        jdbcCallback.setFileService(fileService);
        return jdbcCallback;
    }
}

