/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file.support;

import com.iplatform.base.util.UserUtils;
import com.iplatform.file.FileStoreCallback;
import com.iplatform.file.service.FileServiceImpl;
import com.iplatform.file.util.ImageUtils;
import com.iplatform.model.po.SfAttachment;
import com.iplatform.model.po.SfAttachment_mapper;
import com.walker.file.DefaultFileInfo;
import com.walker.file.FileInfo;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.UserPrincipal;
import com.walker.web.WebRuntimeException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class AttachmentJdbcCallback
implements FileStoreCallback {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private FileServiceImpl fileService;

    @Override
    public void onCallback(FileInfo fileInfo, FileStoreType fileStoreType) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u4fdd\u5b58\u6587\u4ef6:{}", (Object)fileInfo);
        }
        String fileExt = fileInfo.getFileExt();
        SfAttachment attachment = new SfAttachment();
        attachment.setAttId(Long.parseLong(fileInfo.getId()));
        attachment.setCreateTime(DateUtils.getDateTimeNumber());
        attachment.setUpdateTime(attachment.getCreateTime());
        try {
            UserPrincipal userPrincipal = UserUtils.getCurrentUserPrincipal();
            if (userPrincipal != null) {
                attachment.setUserName(userPrincipal.getUserName());
            } else {
                attachment.setUserName("\u524d\u7aef\u7528\u6237");
            }
        }
        catch (WebRuntimeException ex) {
            this.logger.debug("\u672a\u627e\u5230\u5f53\u524d\u7528\u6237\uff0c\u6587\u4ef6\u8bb0\u5f55\u4eba\u4e3a\u7a7a");
            attachment.setUserName("\u672a\u77e5\u7528\u6237");
        }
        attachment.setName(fileInfo.getFileName());
        attachment.setSattDir(fileInfo.getUrl());
        attachment.setAttType(fileExt);
        attachment.setAttSize(fileInfo.getFileSize());
        attachment.setFileStoreType(fileStoreType.getIndex());
        if (StringUtils.isNotEmpty((String)fileInfo.getGroupId())) {
            attachment.setGroupId(fileInfo.getGroupId());
        }
        if (ImageUtils.isImage(fileExt) || ImageUtils.isVideo(fileExt)) {
            attachment.setImageType(1);
        } else {
            attachment.setImageType(0);
        }
        attachment.setPid(fileInfo.getBusinessType());
        String owner = fileInfo.getOwner();
        if (StringUtils.isEmpty((String)owner)) {
            attachment.setOwner(-1);
        } else {
            attachment.setOwner(Integer.parseInt(owner));
        }
        this.fileService.insert(attachment);
    }

    @Override
    public FileInfo onAcquireFileInfo(String id) {
        SfAttachment attachment = (SfAttachment)this.fileService.get(new SfAttachment(Long.parseLong(id)));
        if (attachment == null) {
            return null;
        }
        return this.toFileInfo(attachment);
    }

    @Override
    public List<FileInfo> onAcquireFileInfoList(List<String> ids) {
        if (StringUtils.isEmptyList(ids)) {
            return null;
        }
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("ids", ids);
        List list = this.fileService.sqlListObjectWhereIn("select * from sf_attachment where att_id in(:ids)", SfAttachment_mapper.ROW_MAPPER, (SqlParameterSource)sqlParameterSource);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>(list.size());
        for (SfAttachment s_file : list) {
            fileInfoList.add(this.toFileInfo(s_file));
        }
        return fileInfoList;
    }

    private FileInfo toFileInfo(SfAttachment attachment) {
        if (attachment == null) {
            return null;
        }
        DefaultFileInfo fileInfo = new DefaultFileInfo();
        fileInfo.setId(String.valueOf(attachment.getAttId()));
        fileInfo.setFileSize(attachment.getAttSize().longValue());
        fileInfo.setUrl(attachment.getSattDir());
        fileInfo.setFileExt(attachment.getAttType());
        fileInfo.setFileName(attachment.getName());
        fileInfo.setFileStoreType(FileStoreType.getType((String)attachment.getFileStoreType()));
        fileInfo.setGroupId(attachment.getGroupId());
        fileInfo.setBusinessType(attachment.getPid().intValue());
        fileInfo.setOwner(String.valueOf(attachment.getOwner()));
        return fileInfo;
    }

    public void setFileService(FileServiceImpl fileService) {
        this.fileService = fileService;
    }
}

