/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file.support;

import com.iplatform.base.util.UserUtils;
import com.iplatform.file.FileStoreCallback;
import com.iplatform.file.service.FileServiceImpl;
import com.iplatform.model.po.S_file;
import com.iplatform.model.po.S_file_mapper;
import com.walker.file.DefaultFileInfo;
import com.walker.file.FileInfo;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

@Deprecated
public class JdbcCallback
implements FileStoreCallback {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private FileServiceImpl fileService;

    @Override
    public void onCallback(FileInfo fileInfo, FileStoreType fileStoreType) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u4fdd\u5b58\u6587\u4ef6:{}", (Object)fileInfo);
        }
        S_file s_file = new S_file();
        s_file.setId(Long.parseLong(fileInfo.getId()));
        s_file.setCreate_time(DateUtils.getDateTimeNumber((long)System.currentTimeMillis()));
        s_file.setUser_name(UserUtils.getUserInfo().getUser_name());
        s_file.setFile_name(fileInfo.getFileName());
        s_file.setFile_ext(fileInfo.getFileExt());
        s_file.setContent_type("");
        s_file.setFile_path(fileInfo.getUrl());
        s_file.setFile_size(fileInfo.getFileSize());
        s_file.setFile_store_type(fileStoreType.getIndex());
        if (StringUtils.isNotEmpty((String)fileInfo.getGroupId())) {
            s_file.setGroup_id(fileInfo.getGroupId());
        }
        this.fileService.insert(s_file);
    }

    @Override
    public FileInfo onAcquireFileInfo(String id) {
        S_file s_file = (S_file)this.fileService.get(new S_file(Long.parseLong(id)));
        return this.toFileInfo(s_file);
    }

    @Override
    public List<FileInfo> onAcquireFileInfoList(List<String> ids) {
        if (StringUtils.isEmptyList(ids)) {
            return null;
        }
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("ids", ids);
        List list = this.fileService.sqlListObjectWhereIn("select * from s_file where id in(:ids)", S_file_mapper.ROW_MAPPER, (SqlParameterSource)sqlParameterSource);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>(list.size());
        for (S_file s_file : list) {
            fileInfoList.add(this.toFileInfo(s_file));
        }
        return fileInfoList;
    }

    private FileInfo toFileInfo(S_file s_file) {
        if (s_file == null) {
            return null;
        }
        DefaultFileInfo fileInfo = new DefaultFileInfo();
        fileInfo.setId(String.valueOf(s_file.getId()));
        fileInfo.setFileSize(s_file.getFile_size().longValue());
        fileInfo.setUrl(s_file.getFile_path());
        fileInfo.setFileExt(s_file.getFile_ext());
        fileInfo.setFileName(s_file.getFile_name());
        fileInfo.setFileStoreType(FileStoreType.getType((String)s_file.getFile_store_type()));
        fileInfo.setGroupId(s_file.getGroup_id());
        return fileInfo;
    }

    public void setFileService(FileServiceImpl fileService) {
        this.fileService = fileService;
    }
}

