/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file.util;

import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ImageUtils {
    public static final String IMAGE_JPG = "jpg";
    public static final String IMAGE_JPEG = "jpeg";
    public static final String IMAGE_PNG = "png";
    public static final String IMAGE_GIF = "gif";
    public static final String IMAGE_BMP = "bmp";
    public static final String VIDEO_MP4 = "mp4";
    public static final String VIDEO_MPEG = "mpeg";
    public static final String AUDIO_MP3 = "mp3";
    public static final String DOC_TXT = "txt";
    public static final String DOC_WORD = "docx";
    public static final String DOC_EXCEL = "xlsx";
    public static final String DOC_PDF = "pdf";
    public static final String CONTENT_TYPE_MEDIA = "audio/mpeg";
    public static final String CONTENT_TYPE_VIDEO = "video/mp4";
    public static final String CONTENT_TYPE_TEXT = "text/plain";

    public static final List<String> acquireFileTypeList(String attTypes) {
        String[] attTypeArray;
        ArrayList<String> resultList = new ArrayList<String>(8);
        for (String attType : attTypeArray = StringUtils.commaDelimitedListToStringArray((String)attTypes)) {
            if (attType.equals(CONTENT_TYPE_MEDIA)) {
                resultList.add(VIDEO_MPEG);
                resultList.add(AUDIO_MP3);
                continue;
            }
            if (attType.equals(CONTENT_TYPE_VIDEO)) {
                resultList.add(VIDEO_MP4);
                continue;
            }
            if (attType.equals(CONTENT_TYPE_TEXT)) {
                resultList.add(DOC_TXT);
                resultList.add(DOC_WORD);
                resultList.add(DOC_EXCEL);
                resultList.add(DOC_PDF);
                continue;
            }
            resultList.add(attType);
        }
        return resultList;
    }

    public static final boolean isImage(String fileExt) {
        if (StringUtils.isEmpty((String)fileExt)) {
            return false;
        }
        return fileExt.indexOf(IMAGE_JPEG) >= 0 || fileExt.indexOf(IMAGE_JPG) >= 0 || fileExt.indexOf(IMAGE_PNG) >= 0 || fileExt.indexOf(IMAGE_GIF) >= 0 || fileExt.indexOf(IMAGE_BMP) >= 0;
    }

    public static final boolean isVideo(String fileExt) {
        if (StringUtils.isEmpty((String)fileExt)) {
            return false;
        }
        return fileExt.indexOf(VIDEO_MP4) >= 0;
    }
}

