/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.file;

import com.iplatform.base.FileOperateSpi;
import com.iplatform.base.config.FileProperties;
import com.iplatform.core.BeanContextAware;
import com.iplatform.file.FileEngineFactory;
import com.iplatform.file.util.FileStoreUtils;
import com.walker.file.FileInfo;
import com.walker.file.FileStoreType;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.ElementNotFoundException;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileOperateSpi
implements FileOperateSpi {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int FILE_CONTEXT_LENGTH = "/file/".length();
    private FileStoreType ossFileStoreType = null;
    private String ossPrefix = null;
    private Boolean remoteAsLocal = null;
    private String localFileRoot = null;

    public FileStoreType getOssFileStoreType() {
        if (this.ossFileStoreType == null) {
            this.ossFileStoreType = FileStoreType.getType((String)this.getFileProperties().getOssType());
        }
        return this.ossFileStoreType;
    }

    public String getOssPrefix() {
        if (this.ossPrefix == null) {
            this.ossPrefix = this.getFileProperties().getOssPrefix();
        }
        return this.ossPrefix;
    }

    public byte[] downloadOssFile(String id) {
        return this.acquireFileEngineFactory().downloadOssFile(this.getOssFileStoreType(), id);
    }

    public String clearCdnPrefix(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return path;
        }
        int fileIndex = path.indexOf("/file/");
        if (fileIndex > 0) {
            return path.substring(fileIndex + FILE_CONTEXT_LENGTH, path.length());
        }
        String prefix = this.getCdnUrl() + "/";
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (path.contains(prefix)) {
            if (path.contains("callback/alipay")) {
                return path;
            }
            return path.replace(prefix, "");
        }
        return path;
    }

    public String getCdnUrl() {
        Variable uploadTypeVar = this.acquireArgumentsManager().getVariable("uploadType");
        if (uploadTypeVar == null) {
            throw new ElementNotFoundException("\u53c2\u6570\u672a\u627e\u5230\uff1auploadType");
        }
        String uploadUrl = null;
        String uploadType = uploadTypeVar.getStringValue();
        uploadUrl = FileStoreUtils.getFileUrlPrefixKey(uploadType);
        return this.acquireArgumentsManager().getVariable(uploadUrl).getStringValue();
    }

    public FileInfo uploadFileToLocal(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner) throws Exception {
        return this.acquireFileEngineFactory().uploadFileToLocal(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo[] uploadFileToLocal(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws Exception {
        return this.acquireFileEngineFactory().uploadFileToLocal(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo uploadFileToFtp(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner) throws Exception {
        return this.acquireFileEngineFactory().uploadFileToFtp(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo[] uploadFileToFtp(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner) throws Exception {
        return this.acquireFileEngineFactory().uploadFileToFtp(inputStream, fileName, groupId, fileSize, businessType, owner);
    }

    public FileInfo uploadFileToOss(InputStream inputStream, String fileName, String groupId, long fileSize, Integer businessType, String owner, FileStoreType ossType) throws Exception {
        return this.acquireFileEngineFactory().uploadFileToOss(inputStream, fileName, groupId, fileSize, businessType, owner, ossType);
    }

    public FileInfo[] uploadFileToOss(InputStream[] inputStream, String[] fileName, String groupId, long[] fileSize, Integer businessType, String owner, FileStoreType ossType) throws Exception {
        return this.acquireFileEngineFactory().uploadFileToOss(inputStream, fileName, groupId, fileSize, businessType, owner, ossType);
    }

    @Deprecated
    public FileInfo uploadFileToSystem(InputStream inputStream, String fileName, String groupId, long fileSize) throws Exception {
        return this.acquireFileEngineFactory().uploadFileToSystem(inputStream, fileName, groupId, fileSize);
    }

    @Deprecated
    public FileInfo uploadFileToFtp(InputStream inputStream, String fileName, String groupId, long fileSize) throws Exception {
        return this.acquireFileEngineFactory().uploadFileToFtp(inputStream, fileName, groupId, fileSize);
    }

    public FileInfo getFileInfo(long id) {
        return this.acquireFileEngineFactory().getFileInfo(String.valueOf(id));
    }

    public List<FileInfo> getFileInfoList(List<String> ids) {
        return this.acquireFileEngineFactory().getFileInfoList(ids);
    }

    public String getFileRootConfig() {
        if (this.localFileRoot == null) {
            this.localFileRoot = this.getFileProperties().getFileRoot();
        }
        return this.localFileRoot;
    }

    public boolean isRemoteAsLocal() {
        if (this.remoteAsLocal == null) {
            this.remoteAsLocal = this.getFileProperties().isRemoteAsLocal();
        }
        return this.remoteAsLocal;
    }

    private FileProperties getFileProperties() {
        return (FileProperties)BeanContextAware.getBeanByType(FileProperties.class);
    }

    private FileEngineFactory acquireFileEngineFactory() {
        return (FileEngineFactory)BeanContextAware.getBeanByType(FileEngineFactory.class);
    }

    private ArgumentsManager acquireArgumentsManager() {
        return (ArgumentsManager)BeanContextAware.getBeanByType(ArgumentsManager.class);
    }
}

